/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests;

import com.michelin.cio.jenkins.plugin.requests.Messages;
import com.michelin.cio.jenkins.plugin.requests.action.RequestMailSender;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteBuildRequest;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteFolderRequest;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteJobRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RenameFolderRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RenameJobRequest;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.UnlockRequest;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RequestsPlugin
extends Plugin {
    private List<Request> requests = new ArrayList<Request>();
    private static final Logger LOGGER = Logger.getLogger(RequestsPlugin.class.getName());
    private transient List<String> errors = new ArrayList<String>();

    public void addRequest(Request request) {
        boolean alreadyRequested = false;
        for (int i = 0; i < this.requests.size(); ++i) {
            String projectFullName = this.requests.get(i).getProjectFullName();
            String buildNumber = this.requests.get(i).getBuildNumber();
            String requestType = this.requests.get(i).getRequestType();
            if (!projectFullName.equals(request.getProjectFullName()) || !buildNumber.equals(request.getBuildNumber()) || !requestType.equals(request.getRequestType())) continue;
            alreadyRequested = true;
            break;
        }
        if (!alreadyRequested) {
            this.requests.add(request);
            this.persistPendingRequests();
        }
    }

    public void addRequestPlusEmail(Request request, String[] emailData) throws UnknownHostException, MessagingException {
        boolean alreadyRequested = false;
        for (int i = 0; i < this.requests.size(); ++i) {
            String projectFullName = this.requests.get(i).getProjectFullName();
            String buildNumber = this.requests.get(i).getBuildNumber();
            String requestType = this.requests.get(i).getRequestType();
            if (!projectFullName.equals(request.getProjectFullName()) || !buildNumber.equals(request.getBuildNumber()) || !requestType.equals(request.getRequestType())) continue;
            alreadyRequested = true;
            break;
        }
        if (!alreadyRequested) {
            this.requests.add(request);
            RequestMailSender mailSender = new RequestMailSender(emailData[0], emailData[1], emailData[2], emailData[3]);
            mailSender.executeEmail();
            this.persistPendingRequests();
        }
    }

    @RequirePOST
    public HttpResponse doManageRequests(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.errors.clear();
        String[] selectedRequests = request.getParameterValues("selected");
        ArrayList<Integer> selectedIndexs = new ArrayList<Integer>();
        ArrayList<Request> requestsToRemove = new ArrayList<Request>();
        if (selectedRequests != null && selectedRequests.length > 0) {
            for (String sindex : selectedRequests) {
                if (StringUtils.isNotBlank((String)sindex)) {
                    int index = Integer.parseInt(sindex);
                    Request currentRequest = this.requests.get(index);
                    selectedIndexs.add(index);
                    if (StringUtils.isNotBlank((String)request.getParameter("apply"))) {
                        String requestType = currentRequest.getRequestType();
                        if (currentRequest.process(requestType)) {
                            requestsToRemove.add(currentRequest);
                            continue;
                        }
                        this.errors.add(currentRequest.getErrorMessage().toString());
                        LOGGER.info("[WARNING] The request can not be processed: " + currentRequest.getMessage().toString());
                        continue;
                    }
                    requestsToRemove.add(currentRequest);
                    LOGGER.info("[INFO] The request has been discarded: " + currentRequest.getMessage().toString());
                    continue;
                }
                this.errors.add("The request index is not defined");
                LOGGER.info("[WARNING] The request index is not defined");
            }
        } else {
            this.errors.add("No Requests selected");
            LOGGER.info("[INFO] Nothing selected");
        }
        if (!requestsToRemove.isEmpty()) {
            this.removeAllRequests(selectedIndexs);
        }
        return new HttpRedirect(".");
    }

    public List<Request> getRequests() {
        ArrayList<Request> requests2 = new ArrayList<Request>();
        requests2.addAll(this.requests);
        return requests2;
    }

    public List<String> getErrors() {
        ArrayList<String> errors2 = new ArrayList<String>();
        errors2.addAll(this.errors);
        return errors2;
    }

    public void setErrors(String errorString) {
        this.errors.clear();
        this.errors.add(errorString);
    }

    private void persistPendingRequests() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOGGER.info("[WARNING] Failed to persist the pending requests");
        }
    }

    public void removeAllRequests(ArrayList<Integer> selectedIndexs) {
        Collections.sort(selectedIndexs, Collections.reverseOrder());
        for (int i = 0; i < selectedIndexs.size(); ++i) {
            int selectedIndex = selectedIndexs.get(i);
            this.requests.remove(selectedIndex);
        }
        this.persistPendingRequests();
    }

    public void start() throws Exception {
        super.start();
        Hudson.XSTREAM.alias("UnlockRequest", UnlockRequest.class);
        Hudson.XSTREAM.alias("DeleteJobRequest", DeleteJobRequest.class);
        Hudson.XSTREAM.alias("DeleteBuildRequest", DeleteBuildRequest.class);
        Hudson.XSTREAM.alias("RenameJobRequest", RenameJobRequest.class);
        Hudson.XSTREAM.alias("RenameFolderRequest", RenameFolderRequest.class);
        Hudson.XSTREAM.alias("DeleteFolderRequest", DeleteFolderRequest.class);
        Hudson.XSTREAM.alias("RequestsPlugin", RequestsPlugin.class);
        this.load();
    }

    @Extension
    public static final class RequestManagementLink
    extends ManagementLink {
        public String getDescription() {
            return Messages.RequestManagementLink_Description();
        }

        public String getIconFileName() {
            return "/images/48x48/clipboard.png";
        }

        public String getDisplayName() {
            return Messages.RequestManagementLink_DisplayName();
        }

        public String getUrlName() {
            return "plugin/requests";
        }
    }
}

