/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.action.RequestMailSender;
import com.michelin.cio.jenkins.plugin.requests.model.RenameFolderRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RequestRenameFolderAction
implements Action {
    private Folder project;
    private static final Logger LOGGER = Logger.getLogger(RequestRenameFolderAction.class.getName());

    public RequestRenameFolderAction(Folder target) {
        this.project = target;
    }

    @POST
    public HttpResponse doCreateRenameFolderRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String newName = request.getParameter("new-name");
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
                String projectName = this.project.getFullName();
                String projectFullName = this.project.getFullName();
                if (!projectFullName.contains("/job/") && projectFullName.contains("/")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    projectFullName = requestsUtility.constructFolderJobName(projectFullName);
                }
                if (projectName.contains("/")) {
                    String[] projectnameList = projectName.split("/");
                    int nameCount = projectnameList.length;
                    projectName = projectnameList[nameCount - 1];
                }
                LOGGER.info("Rename Folder Request: " + projectName + " - " + projectFullName);
                String[] emailData = new String[]{projectName + " -> " + newName, username, "A Rename Folder", this.project.getAbsoluteUrl()};
                plugin.addRequestPlusEmail(new RenameFolderRequest("renameFolder", username, projectName, projectFullName, newName), emailData);
                LOGGER.log(Level.INFO, "The request to rename the folder {0} to {1} has been sent to the administrator", new Object[]{this.project.getName(), newName});
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestRenameFolderAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/setting.png";
        }
        return null;
    }

    public Folder getProject() {
        return this.project;
    }

    public String getUrlName() {
        return "request-rename-folder";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = this.hasCreatePermission() && !this.hasDeletePermission() && !this.hasConfigurePermission() || this.hasDeletePermission() && !this.hasCreatePermission() && !this.hasConfigurePermission();
        }
        catch (IOException | ServletException e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasConfigurePermission() throws IOException, ServletException {
        return Functions.hasPermission((Object)this.project, (Permission)Item.CONFIGURE);
    }

    private boolean hasCreatePermission() throws IOException, ServletException {
        return Functions.hasPermission((Object)this.project, (Permission)Item.CREATE);
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission((Object)this.project, (Permission)Item.DELETE);
    }

    @Extension
    public static class TransientFolderActionFactoryImpl
    extends TransientActionFactory<Folder> {
        public Collection<? extends Action> createFor(Folder target) {
            RequestMailSender.DescriptorEmailImpl descriptorEmailImpl = new RequestMailSender.DescriptorEmailImpl();
            ArrayList<RequestRenameFolderAction> adminActions = new ArrayList<RequestRenameFolderAction>();
            if (descriptorEmailImpl.isEnableRenameFolder()) {
                adminActions.add(new RequestRenameFolderAction(target));
            }
            return adminActions;
        }

        public Class<Folder> type() {
            return Folder.class;
        }
    }
}

