/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SafeParametersAction
extends ParametersAction {
    @Nonnull
    private final List<ParameterValue> parameters;

    public SafeParametersAction(@Nonnull List<ParameterValue> parameters) {
        super(new ParameterValue[0]);
        this.parameters = parameters;
    }

    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue p : this.parameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Extension
    public static final class SafeParametersActionEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            SafeParametersAction action = (SafeParametersAction)r.getAction(SafeParametersAction.class);
            if (action != null) {
                for (ParameterValue p : action.getParameters()) {
                    envs.put(p.getName(), String.valueOf(p.getValue()));
                }
            }
        }
    }
}

