/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release.dashboard;

import hudson.Extension;
import hudson.FeedAdapter;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.release.ReleaseWrapper;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.RunList;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.JenkinsLocationConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RecentReleasesPortlet
extends DashboardPortlet {
    @DataBoundConstructor
    public RecentReleasesPortlet(String name) {
        super(name);
    }

    public Collection<Run> getRecentReleases(int max) {
        LinkedList<Run> recentReleases = new LinkedList<Run>();
        for (Job job : this.getDashboard().getJobs()) {
            ReleaseWrapper.ReleaseBuildBadgeAction rbb;
            for (Run run = job.getLastCompletedBuild(); !(run == null || recentReleases.size() >= max && run.getTimestamp().compareTo(recentReleases.getLast().getTimestamp()) <= 0 || (rbb = (ReleaseWrapper.ReleaseBuildBadgeAction)run.getAction(ReleaseWrapper.ReleaseBuildBadgeAction.class)) != null && !this.insertRun(run, recentReleases, max)); run = run.getPreviousBuild()) {
            }
        }
        return recentReleases;
    }

    public String getReleaseVersion(Run run) {
        ReleaseWrapper.ReleaseBuildBadgeAction rbb = (ReleaseWrapper.ReleaseBuildBadgeAction)run.getAction(ReleaseWrapper.ReleaseBuildBadgeAction.class);
        return rbb.getReleaseVersion();
    }

    private boolean insertRun(Run run, LinkedList<Run> recentReleases, int max) {
        ListIterator<Run> iter = recentReleases.listIterator();
        Run recentRun = null;
        do {
            if (((recentRun = iter.hasNext() ? (Run)iter.next() : null) != null || recentReleases.size() >= max) && (recentRun == null || run.getTimestamp().compareTo(recentRun.getTimestamp()) <= 0)) continue;
            if (!recentReleases.isEmpty() && recentRun != null) {
                iter.previous();
            }
            iter.add(run);
            if (recentReleases.size() > max) {
                recentReleases.removeLast();
            }
            return true;
        } while (recentRun != null);
        return false;
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", RunList.fromRuns(this.getRecentReleases(20)));
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " failed builds", RunList.fromRuns(this.getRecentReleases(20)).failureOnly());
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs) throws IOException, ServletException {
        RSS.forwardToRss((String)(this.getDisplayName() + suffix), (String)(this.getDashboard().getUrl() + this.getUrl()), (Collection)runs.newBuilds(), (FeedAdapter)new RelativePathFeedAdapter(this.getDashboard().getUrl() + this.getUrl()), (StaplerRequest)req, (HttpServletResponse)rsp);
    }

    private class RelativePathFeedAdapter
    implements FeedAdapter<Run> {
        private String url;

        RelativePathFeedAdapter(String url) {
            this.url = url;
        }

        public String getEntryTitle(Run entry) {
            return entry + " (" + entry.getResult() + ")";
        }

        public String getEntryUrl(Run entry) {
            return this.url + entry.getUrl();
        }

        public String getEntryID(Run entry) {
            return "tag:hudson.dev.java.net," + entry.getTimestamp().get(1) + ":" + entry.getParent().getName() + ":" + entry.getId();
        }

        public String getEntryDescription(Run entry) {
            return RecentReleasesPortlet.this.getReleaseVersion(entry);
        }

        public Calendar getEntryTimestamp(Run entry) {
            return entry.getTimestamp();
        }

        public String getEntryAuthor(Run entry) {
            List causes = entry.getCauses();
            for (Cause cause : causes) {
                String userName = cause instanceof Cause.UserIdCause ? ((Cause.UserIdCause)cause).getUserName() : (cause instanceof Cause.UserCause ? ((Cause.UserCause)cause).getUserName() : null);
                if (userName == null) continue;
                User usr = User.get((String)userName, (boolean)false, Collections.emptyMap());
                return usr != null ? usr.getFullName() : userName;
            }
            JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
            if (jlc == null) {
                throw new IllegalStateException("JenkinsLocationConfiguration is not available");
            }
            return jlc.getAdminAddress();
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Recent Releases";
        }
    }
}

