/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rocks.inspectit.releaseplugin.JsonHTTPClientWrapper;

public class ConfluenceAccessTool {
    private JsonHTTPClientWrapper client;

    public ConfluenceAccessTool(String url, String user, String password, String proxy) {
        this.client = new JsonHTTPClientWrapper(url, user, password, proxy);
    }

    public void destroy() {
        this.client.destroy();
    }

    public List<Long> getPageIDByTitle(String title, String space) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("spaceKey", space);
            params.put("title", title);
            JsonElement je = this.client.getJson("/rest/api/content", params);
            JsonArray resultsArray = je.getAsJsonObject().get("results").getAsJsonArray();
            ArrayList<Long> results = new ArrayList<Long>();
            for (int i = 0; i < resultsArray.size(); ++i) {
                results.add(resultsArray.get(i).getAsJsonObject().get("id").getAsLong());
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createPage(String title, String htmlContent, String space, Long parentPageID) {
        JsonObject page = new JsonObject();
        page.addProperty("type", "page");
        page.addProperty("title", title);
        if (parentPageID != null) {
            JsonObject parentPage = new JsonObject();
            parentPage.addProperty("type", "page");
            parentPage.addProperty("id", (Number)parentPageID);
            JsonArray ancestors = new JsonArray();
            ancestors.add((JsonElement)parentPage);
            page.add("ancestors", (JsonElement)ancestors);
        }
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", space);
        page.add("space", (JsonElement)spaceObj);
        JsonObject body = new JsonObject();
        JsonObject storage = new JsonObject();
        storage.addProperty("value", htmlContent);
        storage.addProperty("representation", "storage");
        body.add("storage", (JsonElement)storage);
        page.add("body", (JsonElement)body);
        this.client.postJson("/rest/api/content", (JsonElement)page);
    }
}

