/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.versioning;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.AbstractJIRAAction;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;
import rocks.inspectit.releaseplugin.versioning.ModifyAddVersionTemplate;

public class JIRAVersionEditor
extends AbstractJIRAAction {
    private List<ModifyAddVersionTemplate> versionModifiactions;

    @DataBoundConstructor
    public JIRAVersionEditor(String jiraCredentialsID, List<ModifyAddVersionTemplate> versionModifiactions) {
        super(jiraCredentialsID);
        this.versionModifiactions = versionModifiactions == null ? new ArrayList() : versionModifiactions;
    }

    public List<ModifyAddVersionTemplate> getVersionModifiactions() {
        return this.versionModifiactions;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        JIRAProjectCredentials cred = this.getJiraCredentials();
        JIRAAccessTool jira = new JIRAAccessTool(cred.getUrl(), cred.getUrlUsername(), cred.getUrlPassword(), null, cred.getProjectKey(), this.getJiraCredentialsID());
        for (ModifyAddVersionTemplate mod : this.versionModifiactions) {
            mod.applyModifications(jira, varReplacer, logger);
        }
        jira.destroy();
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractJIRAAction.DescriptorImpl {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Add / Modify JIRA Project Versions";
        }
    }
}

