/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.releasenotes;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubWebHook;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;

public class GHSerializableConnection
implements Serializable {
    private static final long serialVersionUID = -5248990998725615329L;
    private String accessToken;
    private String apiUrl;
    private String totalRepoName;
    private Proxy.Type proxyType;
    private SocketAddress proxySocketAdress;

    public GHSerializableConnection(GitHubRepositoryName ghrpn) {
        this.totalRepoName = String.format("%s/%s", ghrpn.getUserName(), ghrpn.getRepositoryName());
        GitHubServerConfig ghsc = null;
        List allConfigs = GitHubPlugin.configuration().getConfigs();
        for (GitHubServerConfig conf : allConfigs) {
            if (!GitHubServerConfig.withHost((String)ghrpn.getHost()).apply((Object)conf)) continue;
            ghsc = conf;
            break;
        }
        this.accessToken = GitHubServerConfig.tokenFor((String)ghsc.getCredentialsId());
        this.apiUrl = ghsc.getApiUrl();
        Jenkins jenkins = GitHubWebHook.getJenkinsInstance();
        if (jenkins.proxy == null) {
            this.proxySocketAdress = null;
        } else {
            Proxy proxyToUse = jenkins.proxy.createProxy(this.apiUrl);
            this.proxyType = proxyToUse.type();
            this.proxySocketAdress = proxyToUse.address();
        }
    }

    public GitHub connect() {
        GitHubBuilder builder = new GitHubBuilder().withOAuthToken(this.accessToken).withConnector(this.buildConnector()).withRateLimitHandler(RateLimitHandler.FAIL);
        try {
            if (this.apiUrl != null && !this.apiUrl.isEmpty()) {
                builder.withEndpoint(this.apiUrl);
            }
            return builder.build();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getTotalRepositoryName() {
        return this.totalRepoName;
    }

    private HttpConnector buildConnector() {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.proxySocketAdress != null) {
            proxy = new Proxy(this.proxyType, this.proxySocketAdress);
        }
        OkHttpClient client = new OkHttpClient().setProxy(proxy);
        client.setConnectTimeout(10L, TimeUnit.MINUTES);
        client.setWriteTimeout(30L, TimeUnit.MINUTES);
        client.setReadTimeout(30L, TimeUnit.MINUTES);
        return new OkHttpConnector(new OkUrlFactory(client));
    }

    private static class OkHttpConnector
    implements HttpConnector {
        private final OkUrlFactory urlFactory;

        private OkHttpConnector(OkUrlFactory urlFactory) {
            this.urlFactory = urlFactory;
        }

        public HttpURLConnection connect(URL url) throws IOException {
            return this.urlFactory.open(url);
        }
    }
}

