/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import rocks.inspectit.releaseplugin.FieldMetadata;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;

public final class JIRAMetadataCache {
    private static final String ISSUE_TYPES = "ISSUE_TYPES";
    private static final String ISSUE_STATUSES = "ISSUE_STATUSES";
    private static final String ISSUE_PRIORITIES = "ISSUE_PRIORITITES";
    private static final String PROJECT_VERSIONS = "PROJECT_VERSIONS";
    private static final String FIELD_METADATA = "FIELD_METADATA";
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> caches = new ConcurrentHashMap();
    private static JIRAMetadataCache singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JIRAMetadataCache getSingleton() {
        if (singleton != null) return singleton;
        Class<JIRAMetadataCache> clazz = JIRAMetadataCache.class;
        synchronized (JIRAMetadataCache.class) {
            if (singleton != null) return singleton;
            singleton = new JIRAMetadataCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private JIRAMetadataCache() {
    }

    public List<String> getAvailableIssueTypes(final String credentialsID) {
        ArrayList result = this.getCreateCacheEntry(credentialsID, ISSUE_TYPES, new Supplier<List<String>>(){

            @Override
            public List<String> get() {
                return (List)JIRAMetadataCache.this.unsafeExecuteJiraCommands(credentialsID, new Function<JIRAAccessTool, List<String>>(){

                    @Override
                    public List<String> apply(JIRAAccessTool jira) {
                        return Collections.unmodifiableList(jira.getAvailableIssueTypes());
                    }
                });
            }
        });
        return result == null ? new ArrayList() : result;
    }

    public List<String> getAvailableIssueStatuses(final String credentialsID) {
        ArrayList result = this.getCreateCacheEntry(credentialsID, ISSUE_STATUSES, new Supplier<List<String>>(){

            @Override
            public List<String> get() {
                return (List)JIRAMetadataCache.this.unsafeExecuteJiraCommands(credentialsID, new Function<JIRAAccessTool, List<String>>(){

                    @Override
                    public List<String> apply(JIRAAccessTool jira) {
                        return Collections.unmodifiableList(jira.getAvailableIssueStatuses());
                    }
                });
            }
        });
        return result == null ? new ArrayList() : result;
    }

    public List<String> getAvailableIssuePriorities(final String credentialsID) {
        ArrayList result = this.getCreateCacheEntry(credentialsID, ISSUE_PRIORITIES, new Supplier<List<String>>(){

            @Override
            public List<String> get() {
                return (List)JIRAMetadataCache.this.unsafeExecuteJiraCommands(credentialsID, new Function<JIRAAccessTool, List<String>>(){

                    @Override
                    public List<String> apply(JIRAAccessTool jira) {
                        return Collections.unmodifiableList(jira.getAvailableIssuePriorities());
                    }
                });
            }
        });
        return result == null ? new ArrayList() : result;
    }

    public List<String> getAvailableVersions(final String credentialsID) {
        ArrayList result = this.getCreateCacheEntry(credentialsID, PROJECT_VERSIONS, new Supplier<List<String>>(){

            @Override
            public List<String> get() {
                return (List)JIRAMetadataCache.this.unsafeExecuteJiraCommands(credentialsID, new Function<JIRAAccessTool, List<String>>(){

                    @Override
                    public List<String> apply(JIRAAccessTool jira) {
                        return Collections.unmodifiableList(jira.getAvailableVersions());
                    }
                });
            }
        });
        return result == null ? new ArrayList() : result;
    }

    public List<FieldMetadata> getFieldMetadata(final String credentialsID) {
        ArrayList result = this.getCreateCacheEntry(credentialsID, FIELD_METADATA, new Supplier<List<FieldMetadata>>(){

            @Override
            public List<FieldMetadata> get() {
                return (List)JIRAMetadataCache.this.unsafeExecuteJiraCommands(credentialsID, new Function<JIRAAccessTool, List<FieldMetadata>>(){

                    @Override
                    public List<FieldMetadata> apply(JIRAAccessTool jira) {
                        return Collections.unmodifiableList(jira.getAvailableFields());
                    }
                });
            }
        });
        return result == null ? new ArrayList() : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getCreateCacheEntry(String credentialsID, String entryID, Supplier<? extends T> initialization) {
        Object entry;
        ConcurrentHashMap<String, Object> cache = this.caches.get(credentialsID);
        if (cache == null) {
            this.caches.putIfAbsent(credentialsID, new ConcurrentHashMap());
            cache = this.caches.get(credentialsID);
        }
        if ((entry = cache.get(entryID)) == null) {
            ConcurrentHashMap<String, Object> concurrentHashMap = cache;
            synchronized (concurrentHashMap) {
                entry = cache.get(entryID);
                if (entry == null && (entry = initialization.get()) != null) {
                    cache.put(entryID, entry);
                }
            }
        }
        return (T)entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T unsafeExecuteJiraCommands(String credentialsID, Function<JIRAAccessTool, T> commands) {
        T t;
        JIRAProjectCredentials cred = JIRAProjectCredentials.getByID(credentialsID);
        JIRAAccessTool jira = null;
        try {
            jira = new JIRAAccessTool(cred.getUrl(), cred.getUrlUsername(), cred.getUrlPassword(), null, cred.getProjectKey(), credentialsID);
            t = commands.apply(jira);
        }
        catch (Exception e) {
            T t2 = null;
            return t2;
        }
        finally {
            if (jira != null) {
                try {
                    jira.destroy();
                }
                catch (Exception exception) {}
            }
        }
        return t;
    }

    public static interface Supplier<R> {
        public R get();
    }

    public static interface Function<P, R> {
        public R apply(P var1);
    }
}

