/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.AncestorInPath;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;

public abstract class AbstractJIRAAction
extends Builder {
    private String jiraCredentialsID;

    public AbstractJIRAAction(String jiraCredentialsID) {
        this.jiraCredentialsID = jiraCredentialsID;
    }

    public String getJiraCredentialsID() {
        return this.jiraCredentialsID;
    }

    public JIRAProjectCredentials getJiraCredentials() {
        return JIRAProjectCredentials.getByID(this.jiraCredentialsID);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    protected StrSubstitutor getVariablesSubstitutor(AbstractBuild<?, ?> build, BuildListener lis) {
        EnvVars env;
        ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
        HashMap variables = new HashMap();
        try {
            env = build.getEnvironment((TaskListener)lis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry en : env.entrySet()) {
            variables.put(en.getKey(), en.getValue());
        }
        if (params != null) {
            for (ParameterValue val : params.getParameters()) {
                if (val.getValue() == null) continue;
                variables.put(val.getName(), val.getValue().toString());
            }
        }
        StrSubstitutor subs = new StrSubstitutor(variables);
        return subs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static abstract class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillJiraCredentialsIDItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(JIRAProjectCredentials.class, context, (Authentication)ACL.SYSTEM));
        }
    }
}

