/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class JsonHTTPClientWrapper {
    private String url;
    private String user;
    private String password;
    private String proxy;
    private CloseableHttpClient client;
    private CredentialsProvider credsProvider;

    public JsonHTTPClientWrapper(String url, String user, String password, String proxy) {
        this.url = url;
        this.password = password;
        this.user = user;
        this.proxy = proxy;
        this.connect();
    }

    private void connect() {
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        HttpClientBuilder clientFactory = HttpClients.custom();
        if (this.proxy != null) {
            clientFactory.setProxy(HttpHost.create((String)this.proxy));
        }
        this.client = clientFactory.setDefaultCredentialsProvider(this.credsProvider).build();
    }

    public String getProxy() {
        return this.proxy;
    }

    public void destroy() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JsonElement executeRequest(HttpUriRequest request) {
        try {
            URI uri = request.getURI();
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            authCache.put(host, (AuthScheme)basicAuth);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(this.credsProvider);
            context.setAuthCache((AuthCache)authCache);
            CloseableHttpResponse response = this.client.execute(request, (HttpContext)context);
            String jsonResponse = new BasicResponseHandler().handleResponse((HttpResponse)response);
            if (jsonResponse != null) {
                return new JsonParser().parse(jsonResponse);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement putJson(String path, JsonElement element) {
        URI requestTarget;
        try {
            requestTarget = new URIBuilder(this.url + path).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpPut putReq = new HttpPut(requestTarget);
        putReq.addHeader("content-type", "application/json");
        putReq.addHeader("Accept", "application/json");
        try {
            putReq.setEntity((HttpEntity)new StringEntity(new Gson().toJson(element)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.executeRequest((HttpUriRequest)putReq);
    }

    public JsonElement postJson(String path, JsonElement element) {
        URI requestTarget;
        try {
            requestTarget = new URIBuilder(this.url + path).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpPost postReq = new HttpPost(requestTarget);
        postReq.addHeader("content-type", "application/json");
        postReq.addHeader("Accept", "application/json");
        try {
            postReq.setEntity((HttpEntity)new StringEntity(new Gson().toJson(element)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.executeRequest((HttpUriRequest)postReq);
    }

    public JsonElement getJson(String path) {
        return this.getJson(path, new HashMap<String, String>());
    }

    public JsonElement getJson(String path, Map<String, String> parameters) {
        URI requestTarget;
        try {
            URIBuilder builder = new URIBuilder(this.url + path);
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                builder.addParameter(e.getKey(), e.getValue());
            }
            requestTarget = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpGet getReq = new HttpGet(requestTarget);
        return this.executeRequest((HttpUriRequest)getReq);
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }
}

