/*
 * Decompiled with CFR 0.152.
 */
package com.midvision.rapiddeploy.plugin.jenkins;

import com.midvision.rapiddeploy.connector.RapidDeployConnector;
import com.midvision.rapiddeploy.plugin.jenkins.postbuildstep.RapidDeployPackageBuilder;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RapidDeployConnectorProxy {
    private static final Log logger = LogFactory.getLog(RapidDeployPackageBuilder.class);
    private List<String> projects;
    private List<String> jobPlans;
    private boolean newConnection = true;

    public boolean isNewConnection() {
        return this.newConnection;
    }

    public void setNewConnection(boolean newConnection) {
        this.newConnection = newConnection;
    }

    public static boolean performPackageBuild(AbstractBuild<?, ?> build, BuildListener listener, String serverUrl, String authenticationToken, String project, String packageName, String archiveExtension) {
        if (StringUtils.isNotBlank((String)packageName)) {
            packageName = RapidDeployConnectorProxy.replaceParametersPlaceholders(packageName, build, listener);
        }
        listener.getLogger().println("Invoking RapidDeploy deployment package builder...");
        listener.getLogger().println("  > Server URL: " + serverUrl);
        listener.getLogger().println("  > Project: " + project);
        listener.getLogger().println("  > Package name: " + packageName);
        listener.getLogger().println("  > Archive extension: " + archiveExtension);
        listener.getLogger().println();
        try {
            String output = RapidDeployConnector.invokeRapidDeployBuildPackage((String)authenticationToken, (String)serverUrl, (String)project, (String)packageName, (String)archiveExtension, (boolean)false, (boolean)true);
            boolean success = true;
            String jobId = RapidDeployConnector.extractJobId((String)output);
            if (jobId != null) {
                listener.getLogger().println("Checking job status every 30 seconds...");
                boolean runningJob = true;
                long milisToSleep = 30000L;
                while (runningJob) {
                    Thread.sleep(milisToSleep);
                    String jobDetails = RapidDeployConnector.pollRapidDeployJobDetails((String)authenticationToken, (String)serverUrl, (String)jobId);
                    String jobStatus = RapidDeployConnector.extractJobStatus((String)jobDetails);
                    listener.getLogger().println("Job status: " + jobStatus);
                    if (jobStatus.equals("DEPLOYING") || jobStatus.equals("QUEUED") || jobStatus.equals("STARTING") || jobStatus.equals("EXECUTING")) {
                        listener.getLogger().println("Job running, next check in 30 seconds...");
                        milisToSleep = 30000L;
                        continue;
                    }
                    if (jobStatus.equals("REQUESTED") || jobStatus.equals("REQUESTED_SCHEDULED")) {
                        listener.getLogger().println("Job in a REQUESTED state. Approval may be required in RapidDeploy to continue with the execution, next check in 30 seconds...");
                        continue;
                    }
                    if (jobStatus.equals("SCHEDULED")) {
                        listener.getLogger().println("Job in a SCHEDULED state, the execution will start in a future date, next check in 5 minutes...");
                        listener.getLogger().println("Printing out job details: ");
                        listener.getLogger().println(jobDetails);
                        milisToSleep = 300000L;
                        continue;
                    }
                    runningJob = false;
                    listener.getLogger().println("Job finished with status: " + jobStatus);
                    if (!jobStatus.equals("FAILED") && !jobStatus.equals("REJECTED") && !jobStatus.equals("CANCELLED") && !jobStatus.equals("UNEXECUTABLE") && !jobStatus.equals("TIMEDOUT") && !jobStatus.equals("UNKNOWN")) continue;
                    success = false;
                }
            } else {
                throw new RuntimeException("Could not retrieve job id, running asynchronously!");
            }
            String logs = RapidDeployConnector.pollRapidDeployJobLog((String)authenticationToken, (String)serverUrl, (String)jobId);
            if (!success) {
                throw new RuntimeException("RapidDeploy job failed. Please check the output." + System.getProperty("line.separator") + logs);
            }
            listener.getLogger().println("RapidDeploy job successfully run. Please check the output.");
            listener.getLogger().println();
            listener.getLogger().println(logs);
            return true;
        }
        catch (Exception e) {
            listener.getLogger().println("Call failed with error: " + e.getMessage());
            return false;
        }
    }

    public static boolean performJobDeployment(AbstractBuild<?, ?> build, BuildListener listener, String serverUrl, String authenticationToken, String project, String target, String packageName, Boolean asynchronousJob) {
        if (StringUtils.isNotBlank((String)packageName)) {
            packageName = RapidDeployConnectorProxy.replaceParametersPlaceholders(packageName, build, listener);
        }
        listener.getLogger().println("Retrieving the list of data dictionary items...");
        HashMap dataDictionary = new HashMap();
        try {
            for (Map.Entry envVar : build.getEnvironment((TaskListener)listener).entrySet()) {
                Pattern pattern = Pattern.compile("@@.+@@");
                Matcher matcher = pattern.matcher((CharSequence)envVar.getKey());
                if (!matcher.matches()) continue;
                dataDictionary.put(envVar.getKey(), envVar.getValue());
            }
        }
        catch (IOException e1) {
            listener.getLogger().println("WARNING: Unable to retrieve the list of parameters. No data dictionary passed to the deployment.");
        }
        catch (InterruptedException e1) {
            listener.getLogger().println("WARNING: Unable to retrieve the list of parameters. No data dictionary passed to the deployment.");
        }
        listener.getLogger().println("Invoking RapidDeploy project deploy via path...");
        listener.getLogger().println("  > Server URL: " + serverUrl);
        listener.getLogger().println("  > Project: " + project);
        listener.getLogger().println("  > Target: " + target);
        listener.getLogger().println("  > Package: " + packageName);
        listener.getLogger().println("  > Asynchronous? " + asynchronousJob);
        listener.getLogger().println("  > Data dictionary: " + dataDictionary);
        listener.getLogger().println();
        try {
            String output = RapidDeployConnector.invokeRapidDeployDeploymentPollOutput((String)authenticationToken, (String)serverUrl, (String)project, (String)target, (String)packageName, (boolean)false, (boolean)true, dataDictionary);
            if (!asynchronousJob.booleanValue()) {
                boolean success = true;
                String jobId = RapidDeployConnector.extractJobId((String)output);
                if (jobId != null) {
                    listener.getLogger().println("Checking job status every 30 seconds...");
                    boolean runningJob = true;
                    long milisToSleep = 30000L;
                    while (runningJob) {
                        Thread.sleep(milisToSleep);
                        String jobDetails = RapidDeployConnector.pollRapidDeployJobDetails((String)authenticationToken, (String)serverUrl, (String)jobId);
                        String jobStatus = RapidDeployConnector.extractJobStatus((String)jobDetails);
                        listener.getLogger().println("Job status: " + jobStatus);
                        if (jobStatus.equals("DEPLOYING") || jobStatus.equals("QUEUED") || jobStatus.equals("STARTING") || jobStatus.equals("EXECUTING")) {
                            listener.getLogger().println("Job running, next check in 30 seconds...");
                            milisToSleep = 30000L;
                            continue;
                        }
                        if (jobStatus.equals("REQUESTED") || jobStatus.equals("REQUESTED_SCHEDULED")) {
                            listener.getLogger().println("Job in a REQUESTED state. Approval may be required in RapidDeploy to continue with the execution, next check in 30 seconds...");
                            continue;
                        }
                        if (jobStatus.equals("SCHEDULED")) {
                            listener.getLogger().println("Job in a SCHEDULED state, the execution will start in a future date, next check in 5 minutes...");
                            listener.getLogger().println("Printing out job details: ");
                            listener.getLogger().println(jobDetails);
                            milisToSleep = 300000L;
                            continue;
                        }
                        runningJob = false;
                        listener.getLogger().println("Job finished with status: " + jobStatus);
                        if (!jobStatus.equals("FAILED") && !jobStatus.equals("REJECTED") && !jobStatus.equals("CANCELLED") && !jobStatus.equals("UNEXECUTABLE") && !jobStatus.equals("TIMEDOUT") && !jobStatus.equals("UNKNOWN")) continue;
                        success = false;
                    }
                } else {
                    throw new RuntimeException("Could not retrieve job id, running asynchronously!");
                }
                String logs = RapidDeployConnector.pollRapidDeployJobLog((String)authenticationToken, (String)serverUrl, (String)jobId);
                if (!success) {
                    throw new RuntimeException("RapidDeploy job failed. Please check the output." + System.getProperty("line.separator") + logs);
                }
                listener.getLogger().println("RapidDeploy job successfully run. Please check the output.");
                listener.getLogger().println();
                listener.getLogger().println(logs);
            }
            return true;
        }
        catch (Exception e) {
            listener.getLogger().println("Call failed with error: " + e.getMessage());
            return false;
        }
    }

    public static boolean performJobPlanRun(BuildListener listener, String serverUrl, String authenticationToken, String jobPlan, Boolean asynchronousJob, Boolean showFullLogs) {
        listener.getLogger().println("Invoking RapidDeploy project deploy via path...");
        listener.getLogger().println("  > Server URL: " + serverUrl);
        listener.getLogger().println("  > jobPlan: " + jobPlan);
        listener.getLogger().println("  > Asynchronous? " + asynchronousJob);
        listener.getLogger().println("  > Show Full Logs? " + showFullLogs);
        listener.getLogger().println();
        String jobPlanId = jobPlan.substring(jobPlan.indexOf("[") + 1, jobPlan.indexOf("]"));
        try {
            String output = RapidDeployConnector.invokeRapidDeployJobPlanPollOutput((String)authenticationToken, (String)serverUrl, (String)jobPlanId, (boolean)true);
            if (!asynchronousJob.booleanValue()) {
                String jobDetails = "";
                boolean success = true;
                String jobId = RapidDeployConnector.extractJobId((String)output);
                if (jobId != null) {
                    listener.getLogger().println("Checking job status every 30 seconds...");
                    boolean runningJob = true;
                    long milisToSleep = 30000L;
                    while (runningJob) {
                        Thread.sleep(milisToSleep);
                        jobDetails = RapidDeployConnector.pollRapidDeployJobDetails((String)authenticationToken, (String)serverUrl, (String)jobId);
                        String jobStatus = RapidDeployConnector.extractJobStatus((String)jobDetails);
                        listener.getLogger().println("Job status: " + jobStatus);
                        if (jobStatus.equals("DEPLOYING") || jobStatus.equals("QUEUED") || jobStatus.equals("STARTING") || jobStatus.equals("EXECUTING")) {
                            listener.getLogger().println("Job running, next check in 30 seconds...");
                            milisToSleep = 30000L;
                            continue;
                        }
                        if (jobStatus.equals("REQUESTED") || jobStatus.equals("REQUESTED_SCHEDULED")) {
                            listener.getLogger().println("Job in a REQUESTED state. Approval may be required in RapidDeploy to continue with the execution, next check in 30 seconds...");
                            continue;
                        }
                        if (jobStatus.equals("SCHEDULED")) {
                            listener.getLogger().println("Job in a SCHEDULED state, the execution will start in a future date, next check in 5 minutes...");
                            listener.getLogger().println("Printing out job details: ");
                            listener.getLogger().println(jobDetails);
                            milisToSleep = 300000L;
                            continue;
                        }
                        runningJob = false;
                        listener.getLogger().println("Job finished with status: " + jobStatus);
                        if (!jobStatus.equals("FAILED") && !jobStatus.equals("REJECTED") && !jobStatus.equals("CANCELLED") && !jobStatus.equals("UNEXECUTABLE") && !jobStatus.equals("TIMEDOUT") && !jobStatus.equals("UNKNOWN")) continue;
                        success = false;
                    }
                } else {
                    throw new RuntimeException("Could not retrieve job id, running asynchronously!");
                }
                String logs = RapidDeployConnector.pollRapidDeployJobLog((String)authenticationToken, (String)serverUrl, (String)jobId);
                StringBuilder fullLogs = new StringBuilder();
                fullLogs.append(logs).append("\n");
                if (showFullLogs.booleanValue()) {
                    List includedJobIds = RapidDeployConnector.extractIncludedJobIdsUnderPipelineJob((String)jobDetails);
                    for (String internalJobId : includedJobIds) {
                        fullLogs.append("LOGS RELATED TO JOB ID: ").append(internalJobId).append("\n");
                        fullLogs.append(RapidDeployConnector.pollRapidDeployJobLog((String)authenticationToken, (String)serverUrl, (String)internalJobId));
                    }
                }
                if (!success) {
                    throw new RuntimeException("RapidDeploy job failed. Please check the output." + System.getProperty("line.separator") + logs);
                }
                listener.getLogger().println("RapidDeploy job successfully run. Please check the output.");
                listener.getLogger().println();
                listener.getLogger().println(fullLogs.toString());
            }
            return true;
        }
        catch (Exception e) {
            listener.getLogger().println("Call failed with error: " + e.getMessage());
            return false;
        }
    }

    private static String replaceParametersPlaceholders(String paramStr, AbstractBuild<?, ?> build, BuildListener listener) {
        listener.getLogger().println("Replacing job parameters for '" + paramStr + "'");
        Pattern pattern = Pattern.compile("\\$\\{[^\\$\\{\\}]+\\}");
        Pattern inPattern = Pattern.compile("\\$\\{(.+)\\}");
        Matcher matcher = pattern.matcher(paramStr);
        while (matcher.find()) {
            String group = matcher.group();
            listener.getLogger().println("Job parameter found: " + group);
            Matcher inMatcher = inPattern.matcher(group);
            if (!inMatcher.matches()) continue;
            try {
                String replaceStr = (String)build.getEnvironment((TaskListener)listener).get((Object)inMatcher.group(1));
                listener.getLogger().println("Job parameter value retrieved: " + replaceStr);
                if (StringUtils.isNotBlank((String)replaceStr)) {
                    listener.getLogger().println("Retrieved value '" + replaceStr + "' from job parameter '" + group + "'");
                    paramStr = paramStr.replace(group, replaceStr);
                    continue;
                }
                listener.getLogger().println("WARNING: job parameter not found '" + group + "'");
            }
            catch (Exception e) {
                listener.getLogger().println("WARNING: Unable to retrieve the job parameter '" + group + "'");
                listener.getLogger().println("         " + e.getMessage());
            }
        }
        listener.getLogger().println("Replaced value '" + paramStr + "'");
        return paramStr;
    }

    public List<String> getProjects(String serverUrl, String authenticationToken) {
        logger.debug((Object)"getProjects");
        if (this.projects == null || this.projects.isEmpty() || this.newConnection) {
            try {
                if (serverUrl != null && !"".equals(serverUrl) && authenticationToken != null && !"".equals(authenticationToken)) {
                    logger.debug((Object)"REQUEST TO WEB SERVICE GET PROJECTS...");
                    this.projects = RapidDeployConnector.invokeRapidDeployListProjects((String)authenticationToken, (String)serverUrl);
                    this.newConnection = false;
                    logger.debug((Object)("PROJECTS RETRIEVED: " + this.projects.size()));
                } else {
                    this.projects = new ArrayList<String>();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
                this.projects = new ArrayList<String>();
            }
        }
        logger.debug((Object)("PROJECTS: " + this.projects.size()));
        return this.projects;
    }

    public List<String> getTargets(String serverUrl, String authenticationToken, String project) throws Exception {
        return RapidDeployConnector.invokeRapidDeployListTargets((String)authenticationToken, (String)serverUrl, (String)project);
    }

    public List<String> getDeploymentPackages(String serverUrl, String authenticationToken, String project, String target) throws Exception {
        String[] targetObjects = target.split("\\.");
        List<String> packageNames = new ArrayList<String>();
        if (target.contains(".") && targetObjects.length == 4) {
            packageNames = RapidDeployConnector.invokeRapidDeployListPackages((String)authenticationToken, (String)serverUrl, (String)project, (String)targetObjects[0], (String)targetObjects[1], (String)targetObjects[2]);
        } else if (target.contains(".") && targetObjects.length == 3) {
            packageNames = RapidDeployConnector.invokeRapidDeployListPackages((String)authenticationToken, (String)serverUrl, (String)project, (String)targetObjects[0], (String)targetObjects[1], null);
        } else {
            logger.error((Object)("Invalid target settings found! Target: " + target));
        }
        return packageNames;
    }

    public List<String> getJobPlans(String serverUrl, String authenticationToken) {
        logger.debug((Object)"getJobPlans");
        if (this.jobPlans == null || this.jobPlans.isEmpty() || this.newConnection) {
            try {
                this.jobPlans = new ArrayList<String>();
                if (serverUrl != null && !"".equals(serverUrl) && authenticationToken != null && !"".equals(authenticationToken)) {
                    logger.debug((Object)"REQUEST TO WEB SERVICE GET JOB PLANS...");
                    String jobPlansCallOutput = RapidDeployConnector.invokeRapidDeployJobPlans((String)authenticationToken, (String)serverUrl);
                    Map jobPlansExtracted = RapidDeployConnector.extractJobPlansFromXml((String)jobPlansCallOutput);
                    for (String jobPlanDesc : jobPlansExtracted.values()) {
                        this.jobPlans.add(jobPlanDesc);
                    }
                    this.newConnection = false;
                    logger.debug((Object)("JOB PLANS RETRIEVED: " + this.jobPlans.size()));
                } else {
                    this.jobPlans = new ArrayList<String>();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
                this.jobPlans = new ArrayList<String>();
            }
        }
        logger.debug((Object)("JOB PLANS: " + this.jobPlans.size()));
        return this.jobPlans;
    }

    public String createPackagesTable(String serverUrl, String authenticationToken, String project) {
        List packageNames = new ArrayList();
        try {
            packageNames = RapidDeployConnector.invokeRapidDeployListPackages((String)authenticationToken, (String)serverUrl, (String)project);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
        if (!packageNames.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("<table>");
            int index = 0;
            int limit = 10;
            for (String packageName : packageNames) {
                if ("null".equals(packageName) || packageName.startsWith("Deployment")) continue;
                sb.append("<tr><td class=\"setting-main\">");
                sb.append(packageName);
                sb.append("</td></tr>");
                if (++index < 10) continue;
                break;
            }
            sb.append("</table>");
            return sb.toString();
        }
        return null;
    }
}

