/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.IViewEntry;
import hudson.model.Job;
import hudson.model.JobViewEntry;
import hudson.model.ListView;
import hudson.model.ProjectViewEntry;
import hudson.model.Queue;
import hudson.model.TopLevelItem;
import hudson.model.ViewDescriptor;
import hudson.model.ViewEntryColors;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RadiatorView
extends ListView {
    private static final int DEFAULT_CAPTION_SIZE = 36;
    private static final Logger LOGGER = Logger.getLogger(RadiatorView.class.getName());
    private transient Collection<IViewEntry> entries;
    transient Map<Queue.Item, Integer> placeInQueue = new HashMap<Queue.Item, Integer>();
    transient ViewEntryColors colors;
    @DataBoundSetter
    Boolean showStable = false;
    @DataBoundSetter
    Boolean showStableDetail = false;
    @DataBoundSetter
    Boolean showBuildStability = false;
    @DataBoundSetter
    Boolean highVis = true;
    @DataBoundSetter
    Boolean groupByPrefix = true;
    @DataBoundSetter
    String captionText;
    @DataBoundSetter
    Integer captionSize;
    @DataBoundSetter
    String excludeRegex;

    @DataBoundConstructor
    public RadiatorView(String name) {
        super(name);
    }

    public ViewEntryColors getColors() {
        if (this.colors == null) {
            this.colors = ViewEntryColors.DEFAULT;
        }
        return this.colors;
    }

    public ProjectViewEntry getContents() {
        ProjectViewEntry content = new ProjectViewEntry();
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Jenkins.getActiveInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        LOGGER.fine("Collecting items for view " + this.getViewName());
        this.addItems(this.getItems(), content);
        return content;
    }

    private void addItems(Collection<TopLevelItem> items, ProjectViewEntry content) {
        for (TopLevelItem item : items) {
            LOGGER.fine(item.getName() + " (" + item.getClass() + ")");
            if (item instanceof AbstractFolder) {
                this.addItems(((AbstractFolder)item).getItems(), content);
            }
            if (!(item instanceof Job) || this.isDisabled(item) || this.isExcluded(item)) continue;
            JobViewEntry entry = new JobViewEntry(this, (Job)item);
            content.addBuild(entry);
        }
    }

    private boolean isExcluded(TopLevelItem item) {
        boolean matches = Pattern.matches(this.excludeRegex, item.getFullName());
        LOGGER.log(Level.FINE, "Checking {0}, fullName={1}, excluded={2}", new String[]{item.getName(), item.getFullName(), String.valueOf(matches)});
        return matches;
    }

    private boolean isDisabled(TopLevelItem item) {
        return item instanceof AbstractProject && ((AbstractProject)item).isDisabled();
    }

    public ProjectViewEntry getContentsByPrefix() {
        ProjectViewEntry contents = new ProjectViewEntry();
        ProjectViewEntry allContents = this.getContents();
        HashMap<String, ProjectViewEntry> jobsByPrefix = new HashMap<String, ProjectViewEntry>();
        for (IViewEntry job : allContents.getJobs()) {
            String prefix = this.getPrefix(job.getName());
            ProjectViewEntry project = (ProjectViewEntry)jobsByPrefix.get(prefix);
            if (project == null) {
                project = new ProjectViewEntry(prefix);
                jobsByPrefix.put(prefix, project);
                contents.addBuild(project);
            }
            project.addBuild(job);
        }
        return contents;
    }

    private String getPrefix(String name) {
        if (name.contains("_")) {
            return StringUtils.substringBefore((String)name, (String)"_");
        }
        if (name.contains("-")) {
            return StringUtils.substringBefore((String)name, (String)"-");
        }
        if (name.contains(":")) {
            return StringUtils.substringBefore((String)name, (String)":");
        }
        return "No Project";
    }

    public String getExcludeRegex() {
        return this.excludeRegex;
    }

    protected void submit(StaplerRequest req) throws ServletException, IOException, Descriptor.FormException {
        super.submit(req);
        this.showStable = Boolean.parseBoolean(req.getParameter("showStable"));
        this.showStableDetail = Boolean.parseBoolean(req.getParameter("showStableDetail"));
        this.highVis = Boolean.parseBoolean(req.getParameter("highVis"));
        this.groupByPrefix = Boolean.parseBoolean(req.getParameter("groupByPrefix"));
        this.showBuildStability = Boolean.parseBoolean(req.getParameter("showBuildStability"));
        this.captionText = req.getParameter("captionText");
        this.excludeRegex = req.getParameter("excludeRegex");
        try {
            this.captionSize = Integer.parseInt(req.getParameter("captionSize"));
        }
        catch (NumberFormatException e) {
            this.captionSize = 36;
        }
    }

    public Boolean getShowStable() {
        return this.showStable;
    }

    public Boolean getShowStableDetail() {
        return this.showStableDetail;
    }

    public Boolean getHighVis() {
        return this.highVis;
    }

    public Boolean getGroupByPrefix() {
        return this.groupByPrefix;
    }

    public Boolean getShowBuildStability() {
        return this.showBuildStability;
    }

    public String getCaptionText() {
        return this.captionText;
    }

    public Integer getCaptionSize() {
        return this.captionSize;
    }

    public Collection<Collection<IViewEntry>> toRows(Collection<IViewEntry> jobs, Boolean failingJobs) {
        int jobsPerRow = 1;
        if (failingJobs.booleanValue()) {
            if (jobs.size() > 3) {
                jobsPerRow = 2;
            }
            if (jobs.size() > 9) {
                jobsPerRow = 3;
            }
            if (jobs.size() > 15) {
                jobsPerRow = 4;
            }
        } else {
            jobsPerRow = (int)Math.floor(Math.sqrt(jobs.size()) / 1.5);
        }
        ArrayList<Collection<IViewEntry>> rows = new ArrayList<Collection<IViewEntry>>();
        ArrayList<IViewEntry> current = null;
        int i = 0;
        for (IViewEntry job : jobs) {
            if (i == 0) {
                current = new ArrayList<IViewEntry>();
                rows.add(current);
            }
            current.add(job);
            if (++i < jobsPerRow) continue;
            i = 0;
        }
        return rows;
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public DescriptorImpl() {
            super(RadiatorView.class);
        }

        public String getDisplayName() {
            return "Radiator";
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

