/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.watchdog;

import hudson.Extension;
import hudson.model.AperiodicWork;
import org.jenkinsci.plugins.rabbitmqconsumer.GlobalRabbitmqConfiguration;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQManager;
import org.jenkinsci.plugins.rabbitmqconsumer.watchdog.ConnectionMonitor;

@Extension
public class ReconnectTimer
extends AperiodicWork {
    public static final long DEFAULT_RECCURENCE_TIME = 60000L;
    private static final long INITIAL_DELAY_TIME = 15000L;
    private volatile boolean stopRequested = false;
    private volatile boolean updateChannelRequested = false;
    private long reccurencePeriod = 60000L;

    public ReconnectTimer() {
        this(60000L, false, false);
    }

    public ReconnectTimer(long reccurencePeriod, boolean stopRequested, boolean updateChannelRequested) {
        this.reccurencePeriod = reccurencePeriod;
        this.stopRequested = stopRequested;
        this.updateChannelRequested = updateChannelRequested;
    }

    public long getRecurrencePeriod() {
        return this.reccurencePeriod;
    }

    public void setRecurrencePeriod(long reccurencePeriod) {
        this.reccurencePeriod = reccurencePeriod;
    }

    public void updateChannel() {
        this.updateChannelRequested = true;
    }

    public long getInitialDelay() {
        return 15000L;
    }

    public AperiodicWork getNewInstance() {
        return new ReconnectTimer(this.reccurencePeriod, this.stopRequested, this.updateChannelRequested);
    }

    protected void doAperiodicRun() {
        if (!this.stopRequested) {
            RMQManager manager = RMQManager.getInstance();
            GlobalRabbitmqConfiguration config = GlobalRabbitmqConfiguration.get();
            ConnectionMonitor monitor = ConnectionMonitor.get();
            if (config.isEnableConsumer()) {
                if (!manager.isOpen()) {
                    this.logger.info("watchdog: Reconnect requesting..");
                    monitor.setActivate(true);
                    RMQManager.getInstance().update();
                    this.updateChannelRequested = false;
                } else {
                    if (this.updateChannelRequested) {
                        this.logger.info("watchdog: channel update requesting..");
                        RMQManager.getInstance().update();
                        this.updateChannelRequested = false;
                    }
                    monitor.setActivate(false);
                    monitor.setLastMeanTime(System.currentTimeMillis());
                }
            } else {
                monitor.setActivate(false);
            }
        }
    }

    public void stop() {
        this.stopRequested = true;
    }

    public void start() {
        this.stopRequested = false;
    }

    public static ReconnectTimer get() {
        return (ReconnectTimer)((Object)AperiodicWork.all().get(ReconnectTimer.class));
    }
}

