/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.logger;

import hudson.Extension;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jenkinsci.plugins.rabbitmqconsumer.extensions.MessageQueueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class MessageLogger
extends MessageQueueListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageLogger.class);
    private static final String PLUGIN_NAME = "Message Logger for debug";

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getAppId() {
        return "*";
    }

    @Override
    public void onBind(String queueName) {
        LOGGER.info("Bind to " + queueName);
    }

    @Override
    public void onUnbind(String queueName) {
        LOGGER.info("Unbind from " + queueName);
    }

    @Override
    public void onReceive(String queueName, String contentType, Map<String, Object> headers, byte[] body) {
        String msg;
        try {
            msg = new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            msg = "<Unsupported Encoding>";
        }
        LOGGER.info("Receive: ({}) {}", (Object)contentType, (Object)msg);
    }
}

