/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.extensions;

import com.rabbitmq.client.Channel;
import hudson.ExtensionList;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.tools.ant.ExtensionPoint;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerOperator
extends ExtensionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerOperator.class);

    public abstract void OnOpen(Channel var1, String var2) throws IOException;

    public abstract void OnCloseCompleted(String var1);

    public static void fireOnOpen(RMQConnection rmqConnection) {
        LOGGER.trace("ServerOperator", (Object)"fireOnOpen");
        if (rmqConnection.getConnection() != null) {
            for (ServerOperator l : ServerOperator.all()) {
                try {
                    Channel ch = rmqConnection.getConnection().createChannel();
                    l.OnOpen(ch, rmqConnection.getServiceUri());
                    ch.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught exception from {}#OnOpen().", (Object)((Object)((Object)l)).getClass().getSimpleName());
                }
            }
        }
    }

    public static void fireOnCloseCompleted(RMQConnection rmqConnection) {
        LOGGER.trace("ServerOperator", (Object)"fireOnCloseCompleted");
        for (ServerOperator l : ServerOperator.all()) {
            try {
                l.OnCloseCompleted(rmqConnection.getServiceUri());
            }
            catch (Exception ex) {
                LOGGER.warn("Caught exception during OnCloseCompleted()", (Throwable)ex);
            }
        }
    }

    public static ExtensionList<ServerOperator> all() {
        return Jenkins.getInstance().getExtensionList(ServerOperator.class);
    }
}

