/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.extensions;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.security.ACL;
import java.util.Collection;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageQueueListener
implements ExtensionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageQueueListener.class);

    public abstract String getName();

    public abstract String getAppId();

    public abstract void onBind(String var1);

    public abstract void onUnbind(String var1);

    public abstract void onReceive(String var1, String var2, Map<String, Object> var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireOnReceive(String appId, String queueName, String contentType, Map<String, Object> headers, byte[] body) {
        LOGGER.trace("MessageQueueListener", (Object)"fireOnReceive");
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            for (MessageQueueListener l : MessageQueueListener.all()) {
                if (!appId.equals(l.getAppId())) continue;
                try {
                    l.onReceive(queueName, contentType, headers, body);
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught exception during calling onReceive()", (Throwable)ex);
                }
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireOnBind(Collection<String> appIds, String queueName) {
        LOGGER.trace("MessageQueueListener", (Object)"fireOnBind");
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            for (MessageQueueListener l : MessageQueueListener.all()) {
                if (!appIds.contains(l.getAppId())) continue;
                try {
                    l.onBind(queueName);
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught exception during calling onBind()", (Throwable)ex);
                }
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireOnUnbind(Collection<String> appIds, String queueName) {
        LOGGER.trace("MessageQueueListener", (Object)"fireOnUnbind");
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            for (MessageQueueListener l : MessageQueueListener.all()) {
                if (!appIds.contains(l.getAppId())) continue;
                try {
                    l.onUnbind(queueName);
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught exception during calling onUnbind()", (Throwable)ex);
                }
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    public static ExtensionList<MessageQueueListener> all() {
        return Jenkins.getInstance().getExtensionList(MessageQueueListener.class);
    }
}

