/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.extensions;

import com.rabbitmq.client.AMQP;
import hudson.Extension;
import hudson.ExtensionList;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQManager;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.PublishRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.publishers.PublishResult;

@Extension
public class MessagePublisher {
    Future<PublishResult> publish(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        PublishRMQChannel ch = RMQManager.getInstance().getPublishChannel();
        if (ch != null && ch.isOpen()) {
            return ch.publish(exchangeName, routingKey, props, body);
        }
        return null;
    }

    public static MessagePublisher get() {
        ExtensionList extensions;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (extensions = jenkins.getExtensionList(MessagePublisher.class)) != null && extensions.size() > 0) {
            return (MessagePublisher)extensions.get(0);
        }
        return null;
    }
}

