/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.channels;

import com.rabbitmq.client.AMQP;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.AbstractRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.listeners.RMQChannelListener;
import org.jenkinsci.plugins.rabbitmqconsumer.publishers.ExchangeType;
import org.jenkinsci.plugins.rabbitmqconsumer.publishers.PublishChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.publishers.PublishResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishRMQChannel
extends AbstractRMQChannel
implements PublishChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishRMQChannel.class);
    private final ExecutorService publishExecutor = Executors.newSingleThreadExecutor();

    @Override
    public Future<PublishResult> publish(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        return this.publishExecutor.submit(new PublishTask(exchangeName, routingKey, props, body));
    }

    @Override
    public PublishResult setupExchange(String exchangeName, String queueName) {
        Future<PublishResult> future = this.publishExecutor.submit(new PrepareTask(exchangeName, queueName, ExchangeType.FANOUT, ""));
        PublishResult result = null;
        try {
            result = future.get();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }

    @Override
    public PublishResult setupExchange(String exchangeName, String queueName, ExchangeType exchangeType, String routingKey) {
        Future<PublishResult> future = this.publishExecutor.submit(new PrepareTask(exchangeName, queueName, exchangeType, routingKey));
        PublishResult result = null;
        try {
            result = future.get();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }

    @Override
    public void addListener(RMQChannelListener listener) {
        this.addRMQChannelListener(listener);
    }

    @Override
    public void removeListener(RMQChannelListener listener) {
        this.removeRMQChannelListener(listener);
    }

    public class PrepareTask
    implements Callable<PublishResult> {
        private String exchangeName;
        private String queueName;
        private ExchangeType exchangeType;
        private String routingKey;

        public PrepareTask(String exchangeName, String queueName, ExchangeType exchangeType, String routingKey) {
            this.exchangeName = exchangeName;
            this.queueName = queueName;
            this.exchangeType = exchangeType;
            this.routingKey = routingKey;
        }

        @Override
        public PublishResult call() throws Exception {
            if (PublishRMQChannel.this.channel != null && PublishRMQChannel.this.channel.isOpen()) {
                if (this.queueName == null) {
                    return this.createPublishResult(false, "Queue name should not be null.");
                }
                if (this.exchangeName == null) {
                    this.exchangeName = UUID.randomUUID().toString();
                    try {
                        PublishRMQChannel.this.channel.exchangeDeclare(this.exchangeName, this.exchangeType.name().toLowerCase());
                    }
                    catch (IOException e) {
                        return this.createPublishResult(false, e.getMessage());
                    }
                }
                try {
                    PublishRMQChannel.this.channel.queueBind(this.queueName, this.exchangeName, this.routingKey);
                }
                catch (IOException e) {
                    return this.createPublishResult(false, e.getMessage());
                }
                return this.createPublishResult(true, "SUCCESS");
            }
            return this.createPublishResult(false, "Channel is not opened.");
        }

        PublishResult createPublishResult(boolean isSuccess, String message) {
            return new PublishResult(isSuccess, message, this.exchangeName, this.queueName, this.exchangeType, this.routingKey);
        }
    }

    public class PublishTask
    implements Callable<PublishResult> {
        private String exchangeName;
        private String routingKey;
        private AMQP.BasicProperties props;
        private byte[] body;

        public PublishTask(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
            this.exchangeName = exchangeName;
            this.routingKey = routingKey;
            this.props = props;
            this.body = Arrays.copyOf(body, body.length);
        }

        @Override
        public PublishResult call() throws Exception {
            if (PublishRMQChannel.this.channel != null && PublishRMQChannel.this.channel.isOpen() && this.body != null) {
                try {
                    PublishRMQChannel.this.channel.basicPublish(this.exchangeName, this.routingKey, this.props, this.body);
                    return new PublishResult(true, "Published", this.exchangeName);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to publish message.", (Throwable)e);
                    return new PublishResult(false, "Failed to publish message.", this.exchangeName);
                }
            }
            return new PublishResult(false, "Channel is not opened.", this.exchangeName);
        }
    }
}

