/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.channels;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jenkinsci.plugins.rabbitmqconsumer.GlobalRabbitmqConfiguration;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQState;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.AbstractRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.extensions.MessageQueueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeRMQChannel
extends AbstractRMQChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeRMQChannel.class);
    protected final Collection<String> appIds;
    private final String queueName;
    private volatile boolean consumeStarted = false;
    private final boolean debug;

    public ConsumeRMQChannel(String queueName, Collection<String> appIds) {
        this.appIds = appIds;
        this.queueName = queueName;
        this.debug = this.isEnableDebug();
    }

    public Collection<String> getAppIds() {
        return this.appIds;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void consume() {
        if (this.state == RMQState.CONNECTED && this.channel != null) {
            try {
                this.channel.basicConsume(this.queueName, false, (Consumer)new MessageConsumer(this.channel));
                this.consumeStarted = true;
                MessageQueueListener.fireOnBind(this.appIds, this.queueName);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to start consumer: ", (Throwable)e);
            }
        }
    }

    public boolean isConsumeStarted() {
        return this.consumeStarted;
    }

    private boolean isEnableDebug() {
        return GlobalRabbitmqConfiguration.get().isEnableDebug();
    }

    @Override
    public void shutdownCompleted(ShutdownSignalException shutdownSignalException) {
        this.consumeStarted = false;
        MessageQueueListener.fireOnUnbind(this.appIds, this.queueName);
        super.shutdownCompleted(shutdownSignalException);
    }

    public class MessageConsumer
    extends DefaultConsumer {
        public MessageConsumer(Channel channel) {
            super(channel);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            try {
                long deliveryTag = envelope.getDeliveryTag();
                String contentType = properties.getContentType();
                Map headers = properties.getHeaders();
                if (ConsumeRMQChannel.this.debug && ConsumeRMQChannel.this.appIds.contains("*")) {
                    MessageQueueListener.fireOnReceive("*", ConsumeRMQChannel.this.queueName, contentType, headers, body);
                }
                if (properties.getAppId() != null && !properties.getAppId().equals("*") && ConsumeRMQChannel.this.appIds.contains(properties.getAppId())) {
                    MessageQueueListener.fireOnReceive(properties.getAppId(), ConsumeRMQChannel.this.queueName, contentType, headers, body);
                }
                ConsumeRMQChannel.this.channel.basicAck(deliveryTag, false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.warn("caught exception in delivery handler", (Throwable)e);
            }
        }
    }
}

