/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer.channels;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQState;
import org.jenkinsci.plugins.rabbitmqconsumer.events.RMQChannelEvent;
import org.jenkinsci.plugins.rabbitmqconsumer.listeners.RMQChannelListener;
import org.jenkinsci.plugins.rabbitmqconsumer.notifiers.RMQChannelNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRMQChannel
implements RMQChannelNotifier,
ShutdownListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRMQChannel.class);
    protected Channel channel;
    protected RMQState state = RMQState.DISCONNECTED;
    protected final Collection<RMQChannelListener> rmqChannelListeners = new CopyOnWriteArraySet<RMQChannelListener>();

    public boolean isOpen() {
        return this.state == RMQState.CONNECTED;
    }

    public void open(Connection connection) throws IOException {
        if (this.state == RMQState.DISCONNECTED) {
            this.channel = connection.createChannel();
            if (this.channel != null) {
                this.state = RMQState.CONNECTED;
                this.channel.addShutdownListener((ShutdownListener)this);
                this.notifyOnOpen();
            }
        } else {
            LOGGER.warn("Channel is already opened or on close pending.");
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void close() throws IOException {
        if (this.state == RMQState.CONNECTED) {
            if (this.channel != null) {
                try {
                    this.state = RMQState.CLOSE_PENDING;
                    this.channel.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to close channel.");
                    if (!(ex.getCause() instanceof ShutdownSignalException)) {
                        this.state = RMQState.DISCONNECTED;
                        this.notifyOnCloseCompleted();
                        this.channel = null;
                    }
                    throw ex;
                }
            }
        } else {
            LOGGER.warn("Channel is already closed or on close pending.");
        }
    }

    @Override
    public void addRMQChannelListener(RMQChannelListener rmqChannelListener) {
        this.rmqChannelListeners.add(rmqChannelListener);
    }

    @Override
    public void removeRMQChannelListener(RMQChannelListener rmqChannelListener) {
        this.rmqChannelListeners.remove(rmqChannelListener);
    }

    @Override
    public boolean isOpenRMQChannel() {
        return this.channel.isOpen();
    }

    @Override
    public void notifyRMQChannelListeners(RMQChannelEvent event) {
        for (RMQChannelListener l : this.rmqChannelListeners) {
            if (event == RMQChannelEvent.CLOSE_COMPLETED) {
                l.onCloseCompleted(this);
                continue;
            }
            if (event != RMQChannelEvent.OPEN) continue;
            l.onOpen(this);
        }
    }

    public void notifyOnCloseCompleted() {
        this.notifyRMQChannelListeners(RMQChannelEvent.CLOSE_COMPLETED);
    }

    public void notifyOnOpen() {
        this.notifyRMQChannelListeners(RMQChannelEvent.OPEN);
    }

    public void shutdownCompleted(ShutdownSignalException shutdownSignalException) {
        if (shutdownSignalException != null && !shutdownSignalException.isInitiatedByApplication()) {
            LOGGER.warn("RabbitMQ channel {} was suddenly closed.", (Object)this.channel.getChannelNumber());
        }
        this.state = RMQState.DISCONNECTED;
        this.notifyOnCloseCompleted();
        this.channel = null;
    }
}

