/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer;

import com.rabbitmq.client.Channel;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.HashSet;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.rabbitmqconsumer.GlobalRabbitmqConfiguration;
import org.jenkinsci.plugins.rabbitmqconsumer.Messages;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQManager;
import org.jenkinsci.plugins.rabbitmqconsumer.extensions.MessageQueueListener;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RabbitmqConsumeItem
implements Describable<RabbitmqConsumeItem> {
    public static final String DEBUG_APPID = "*";
    private String appId = null;
    private String queueName = null;

    @DataBoundConstructor
    public RabbitmqConsumeItem(String appId, String queueName) {
        this.appId = StringUtils.stripToNull((String)appId);
        this.queueName = StringUtils.stripToNull((String)queueName);
    }

    public RabbitmqConsumeItem() {
    }

    public final String getAppId() {
        return this.appId;
    }

    public final void setAppId(String appId) {
        this.appId = appId;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Descriptor<RabbitmqConsumeItem> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RabbitmqConsumeItem other = (RabbitmqConsumeItem)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        return !(this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RabbitmqConsumeItem> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillAppIdItems() {
            ListBoxModel items = new ListBoxModel();
            HashSet<String> appIds = new HashSet<String>();
            for (MessageQueueListener l : MessageQueueListener.all()) {
                appIds.add(l.getAppId());
            }
            appIds.remove(null);
            appIds.remove(RabbitmqConsumeItem.DEBUG_APPID);
            items.add("-", "-");
            if (GlobalRabbitmqConfiguration.get().isEnableDebug()) {
                items.add(RabbitmqConsumeItem.DEBUG_APPID, RabbitmqConsumeItem.DEBUG_APPID);
            }
            for (String appId : appIds) {
                items.add(appId, appId);
            }
            return items;
        }

        public FormValidation doCheckQueueName(@QueryParameter String value) {
            Channel ch;
            if (StringUtils.stripToNull((String)value) != null && RMQManager.getInstance().isOpen() && (ch = RMQManager.getInstance().getChannel()) != null) {
                try {
                    ch.queueDeclarePassive(StringUtils.strip((String)value));
                    return FormValidation.ok();
                }
                catch (Exception ex) {
                    return FormValidation.error((String)Messages.NotFound());
                }
            }
            return FormValidation.ok();
        }
    }
}

