/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer;

import hudson.Plugin;
import hudson.model.Api;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.plugins.rabbitmqconsumer.GlobalRabbitmqConfiguration;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQManager;
import org.jenkinsci.plugins.rabbitmqconsumer.RabbitmqConsumeItem;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RabbitMQConsumer
extends Plugin {
    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public boolean isEnabled() {
        return GlobalRabbitmqConfiguration.get().isEnableConsumer();
    }

    @Exported
    public boolean isConnected() {
        return GlobalRabbitmqConfiguration.get().isOpen();
    }

    @Exported
    public String getServiceUri() {
        return GlobalRabbitmqConfiguration.get().getServiceUri();
    }

    @Exported
    public String getUserName() {
        return GlobalRabbitmqConfiguration.get().getUserName();
    }

    @Exported
    public List<QueueState> getQueues() {
        LinkedList<QueueState> stats = new LinkedList<QueueState>();
        List<RabbitmqConsumeItem> queues = GlobalRabbitmqConfiguration.get().getConsumeItems();
        for (RabbitmqConsumeItem queue : queues) {
            QueueState state = new QueueState(queue.getQueueName(), queue.getAppId(), RMQManager.getInstance().getChannelStatus(queue.getQueueName()));
            stats.add(state);
        }
        return stats;
    }

    @ExportedBean(defaultVisibility=2)
    public static final class QueueState {
        @Exported
        public final String name;
        @Exported
        public final String appId;
        @Exported
        public final boolean consumed;

        QueueState(String name, String appId, boolean consumed) {
            this.name = name;
            this.appId = appId;
            this.consumed = consumed;
        }
    }
}

