/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer;

import com.rabbitmq.client.Channel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.plugins.rabbitmqconsumer.GlobalRabbitmqConfiguration;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQConnection;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.PublishRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.extensions.ServerOperator;
import org.jenkinsci.plugins.rabbitmqconsumer.listeners.RMQConnectionListener;
import org.jenkinsci.plugins.rabbitmqconsumer.watchdog.ConnectionMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RMQManager
implements RMQConnectionListener {
    private static final long TIMEOUT_CLOSE = 300000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQManager.class);
    private RMQConnection rmqConnection;
    private volatile boolean statusOpen = false;
    private CountDownLatch closeLatch = null;

    public static RMQManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void update() {
        LOGGER.info("Start to update connections...");
        GlobalRabbitmqConfiguration conf = GlobalRabbitmqConfiguration.get();
        String uri = conf.getServiceUri();
        String user = conf.getUserName();
        Secret pass = conf.getUserPassword();
        long watchdog = conf.getWatchdogPeriod();
        boolean enableConsumer = conf.isEnableConsumer();
        try {
            if (!(enableConsumer && uri != null || this.rmqConnection == null)) {
                this.shutdownWithWait();
                this.rmqConnection = null;
            }
            if (!(this.rmqConnection == null || uri.equals(this.rmqConnection.getServiceUri()) || user.equals(this.rmqConnection.getUserName()) || pass.equals((Object)this.rmqConnection.getUserPassword()))) {
                this.shutdownWithWait();
                this.rmqConnection = null;
            }
            if (enableConsumer) {
                if (this.rmqConnection == null) {
                    this.rmqConnection = new RMQConnection(uri, user, pass, watchdog);
                    this.rmqConnection.addRMQConnectionListener(this);
                    try {
                        this.rmqConnection.open();
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof ConnectException) {
                            LOGGER.warn("Cannot open connection: {}", (Object)e.getCause().getMessage());
                        } else {
                            LOGGER.warn("Cannot open connection!", (Throwable)e);
                        }
                        this.rmqConnection.removeRMQConnectionListener(this);
                        this.rmqConnection = null;
                    }
                } else {
                    this.rmqConnection.updateChannels(GlobalRabbitmqConfiguration.get().getConsumeItems());
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when waiting to close connection.");
        }
    }

    public void shutdown() {
        if (this.rmqConnection != null && this.rmqConnection.isOpen()) {
            try {
                this.statusOpen = false;
                this.rmqConnection.close();
            }
            catch (Exception ex) {
                this.onCloseCompleted(this.rmqConnection);
            }
        }
    }

    public synchronized void shutdownWithWait() throws InterruptedException {
        if (this.rmqConnection != null && this.rmqConnection.isOpen()) {
            try {
                this.closeLatch = new CountDownLatch(1);
                this.shutdown();
                if (!this.closeLatch.await(300000L, TimeUnit.MILLISECONDS)) {
                    this.onCloseCompleted(this.rmqConnection);
                    throw new InterruptedException("Wait timeout");
                }
            }
            finally {
                this.closeLatch = null;
            }
        }
    }

    public boolean isOpen() {
        return this.statusOpen;
    }

    public boolean getChannelStatus(String queueName) {
        if (this.statusOpen && this.rmqConnection != null && this.rmqConnection.isOpen()) {
            return this.rmqConnection.getConsumeChannelStatus(queueName);
        }
        return false;
    }

    public Channel getChannel() {
        Channel ch = null;
        if (this.statusOpen && this.rmqConnection != null) {
            ch = this.rmqConnection.createPureChannel();
        }
        return ch;
    }

    public PublishRMQChannel getPublishChannel() {
        Collection<PublishRMQChannel> channels;
        if (this.statusOpen && this.rmqConnection != null && !(channels = this.rmqConnection.getPublishRMQChannels()).isEmpty()) {
            return (PublishRMQChannel)channels.toArray()[0];
        }
        return null;
    }

    @Override
    public void onOpen(RMQConnection rmqConnection) {
        if (this.rmqConnection.equals(rmqConnection)) {
            LOGGER.info("Open RabbitMQ connection: {}", (Object)rmqConnection.getServiceUri());
            ConnectionMonitor.get().setActivate(false);
            ConnectionMonitor.get().setLastMeanTime(System.currentTimeMillis());
            ServerOperator.fireOnOpen(rmqConnection);
            rmqConnection.updateChannels(GlobalRabbitmqConfiguration.get().getConsumeItems());
            this.statusOpen = true;
        }
    }

    @Override
    public void onCloseCompleted(RMQConnection rmqConnection) {
        if (this.rmqConnection != null && this.rmqConnection.equals(rmqConnection)) {
            this.rmqConnection = null;
            LOGGER.info("Closed RabbitMQ connection: {}", (Object)rmqConnection.getServiceUri());
            rmqConnection.removeRMQConnectionListener(this);
            ServerOperator.fireOnCloseCompleted(rmqConnection);
            this.statusOpen = false;
            if (this.closeLatch != null) {
                this.closeLatch.countDown();
            }
        }
    }

    private RMQManager() {
    }

    private static class InstanceHolder {
        private static final RMQManager INSTANCE = new RMQManager();

        private InstanceHolder() {
        }
    }
}

