/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQState;
import org.jenkinsci.plugins.rabbitmqconsumer.RabbitmqConsumeItem;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.AbstractRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.ConsumeRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.channels.PublishRMQChannel;
import org.jenkinsci.plugins.rabbitmqconsumer.events.RMQConnectionEvent;
import org.jenkinsci.plugins.rabbitmqconsumer.listeners.RMQChannelListener;
import org.jenkinsci.plugins.rabbitmqconsumer.listeners.RMQConnectionListener;
import org.jenkinsci.plugins.rabbitmqconsumer.notifiers.RMQConnectionNotifier;
import org.jenkinsci.plugins.rabbitmqconsumer.watchdog.ConnectionMonitor;
import org.jenkinsci.plugins.rabbitmqconsumer.watchdog.ReconnectTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnection
implements ShutdownListener,
RMQChannelListener,
RMQConnectionNotifier {
    private static final int TIMEOUT_CONNECTION_MILLIS = 30000;
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQConnection.class);
    private final String serviceUri;
    private final String userName;
    private final Secret userPassword;
    private final long watchdogPeriod;
    private final ConnectionFactory factory;
    private Connection connection = null;
    private final Collection<AbstractRMQChannel> rmqChannels = new CopyOnWriteArraySet<AbstractRMQChannel>();
    private final Collection<RMQConnectionListener> rmqConnectionListeners = new CopyOnWriteArraySet<RMQConnectionListener>();
    private volatile RMQState state = RMQState.DISCONNECTED;

    public RMQConnection(String serviceUri, String userName, Secret userPassword) {
        this(serviceUri, userName, userPassword, 60000L);
    }

    public RMQConnection(String serviceUri, String userName, Secret userPassword, long watchdogPeriod) {
        this.serviceUri = serviceUri;
        this.userName = userName;
        this.userPassword = userPassword;
        this.watchdogPeriod = watchdogPeriod;
        this.factory = new ConnectionFactory();
        this.factory.setConnectionTimeout(30000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Channel createPureChannel() {
        Channel ch = null;
        if (this.connection != null && this.connection.isOpen()) {
            try {
                ch = this.connection.createChannel();
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot create channel.");
            }
        }
        return ch;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public String getUserName() {
        return this.userName;
    }

    public Secret getUserPassword() {
        return this.userPassword;
    }

    public Collection<AbstractRMQChannel> getRMQChannels() {
        return this.rmqChannels;
    }

    public Collection<ConsumeRMQChannel> getConsumeRMQChannels() {
        HashSet<ConsumeRMQChannel> channels = new HashSet<ConsumeRMQChannel>();
        for (AbstractRMQChannel ch : this.rmqChannels) {
            if (!(ch instanceof ConsumeRMQChannel)) continue;
            channels.add((ConsumeRMQChannel)ch);
        }
        return channels;
    }

    public Collection<PublishRMQChannel> getPublishRMQChannels() {
        HashSet<PublishRMQChannel> channels = new HashSet<PublishRMQChannel>();
        for (AbstractRMQChannel ch : this.rmqChannels) {
            if (!(ch instanceof PublishRMQChannel)) continue;
            channels.add((PublishRMQChannel)ch);
        }
        return channels;
    }

    public boolean getConsumeChannelStatus(String queueName) {
        for (ConsumeRMQChannel ch : this.getConsumeRMQChannels()) {
            if (!ch.getQueueName().equals(queueName)) continue;
            return ch.isConsumeStarted();
        }
        return false;
    }

    public void open() throws IOException {
        if (this.state == RMQState.DISCONNECTED) {
            try {
                this.factory.setUri(this.serviceUri);
                if (StringUtils.isNotEmpty((CharSequence)this.userName)) {
                    this.factory.setUsername(this.userName);
                }
                if (StringUtils.isNotEmpty((CharSequence)Secret.toString((Secret)this.userPassword))) {
                    this.factory.setPassword(Secret.toString((Secret)this.userPassword));
                }
                this.connection = this.factory.newConnection();
                this.connection.addShutdownListener((ShutdownListener)this);
                this.state = RMQState.CONNECTED;
                this.notifyOnOpen();
            }
            catch (Exception ex) {
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.connection = null;
                    }
                }
                throw new IOException(ex);
            }
            ReconnectTimer timer = ReconnectTimer.get();
            if (timer != null) {
                timer.setRecurrencePeriod(this.watchdogPeriod);
            }
        } else {
            throw new IOException("Connection is already opened.");
        }
    }

    public void close() throws IOException {
        if (this.state == RMQState.CONNECTED) {
            this.state = RMQState.CLOSE_PENDING;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close connection.");
                    if (!(e.getCause() instanceof ShutdownSignalException)) {
                        this.state = RMQState.DISCONNECTED;
                        this.notifyOnCloseCompleted();
                        this.connection = null;
                    }
                    throw e;
                }
            }
        } else {
            LOGGER.warn("Connection is already closed.");
        }
    }

    public boolean isOpen() {
        return this.state == RMQState.CONNECTED;
    }

    public void updateChannels(Collection<RabbitmqConsumeItem> consumeItems) {
        HashSet<String> uniqueQueueNames = new HashSet<String>();
        this.updatePublishChannel();
        if (consumeItems == null) {
            this.closeAllConsumeChannels();
        } else {
            for (RabbitmqConsumeItem i : consumeItems) {
                uniqueQueueNames.add(i.getQueueName());
            }
            uniqueQueueNames.remove(null);
            this.closeUnusedConsumeChannels(uniqueQueueNames);
            this.createNewConsumeChannels(uniqueQueueNames, consumeItems);
        }
    }

    private void createNewConsumeChannels(Collection<String> uniqueQueueNames, Collection<RabbitmqConsumeItem> consumeItems) {
        if (this.state != RMQState.CONNECTED) {
            LOGGER.warn("Cannot create channel because connection is not established.");
            return;
        }
        if (uniqueQueueNames == null || consumeItems == null || uniqueQueueNames.isEmpty() || consumeItems.isEmpty()) {
            LOGGER.info("No create new channel due to empty.");
        } else {
            HashSet<String> existingQueueNames = new HashSet<String>();
            for (ConsumeRMQChannel h : this.getConsumeRMQChannels()) {
                existingQueueNames.add(h.getQueueName());
            }
            for (String queueName : uniqueQueueNames) {
                if (existingQueueNames.contains(queueName)) continue;
                HashSet<String> appIds = new HashSet<String>();
                for (RabbitmqConsumeItem i : consumeItems) {
                    if (!queueName.equals(i.getQueueName())) continue;
                    appIds.add(i.getAppId());
                }
                appIds.remove("-");
                if (appIds.isEmpty()) continue;
                ConsumeRMQChannel ch = new ConsumeRMQChannel(queueName, appIds);
                ch.addRMQChannelListener(this);
                try {
                    ch.open(this.connection);
                    this.rmqChannels.add(ch);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to open consume channel for {}.", (Object)queueName);
                    LOGGER.warn("Exception: {}", (Throwable)e);
                    ch.removeRMQChannelListener(this);
                }
            }
        }
    }

    private void closeUnusedConsumeChannels(Collection<String> usedQueueNames) {
        Collection<ConsumeRMQChannel> channels = this.getConsumeRMQChannels();
        HashSet<ConsumeRMQChannel> unclosedChannels = new HashSet<ConsumeRMQChannel>();
        if (!channels.isEmpty()) {
            for (ConsumeRMQChannel ch : channels) {
                if (usedQueueNames.contains(ch.getQueueName())) continue;
                try {
                    ch.close();
                }
                catch (IOException ex) {
                    unclosedChannels.add(ch);
                }
            }
            if (!unclosedChannels.isEmpty()) {
                for (ConsumeRMQChannel ch : unclosedChannels) {
                    ch.removeRMQChannelListener(this);
                    this.rmqChannels.remove(ch);
                }
            }
        }
    }

    private void closeAllChannels() {
        if (!this.rmqChannels.isEmpty()) {
            HashSet<AbstractRMQChannel> unclosedChannels = new HashSet<AbstractRMQChannel>();
            for (AbstractRMQChannel h : this.rmqChannels) {
                try {
                    h.close();
                }
                catch (IOException ex) {
                    unclosedChannels.add(h);
                }
            }
            if (!unclosedChannels.isEmpty()) {
                for (AbstractRMQChannel h : unclosedChannels) {
                    h.removeRMQChannelListener(this);
                    this.rmqChannels.remove(h);
                }
            }
        }
    }

    private void closeAllConsumeChannels() {
        Collection<ConsumeRMQChannel> channels = this.getConsumeRMQChannels();
        HashSet<ConsumeRMQChannel> unclosedChannels = new HashSet<ConsumeRMQChannel>();
        if (!channels.isEmpty()) {
            for (ConsumeRMQChannel h : channels) {
                try {
                    h.close();
                }
                catch (IOException ex) {
                    unclosedChannels.add(h);
                }
            }
            if (!unclosedChannels.isEmpty()) {
                for (ConsumeRMQChannel h : unclosedChannels) {
                    h.removeRMQChannelListener(this);
                    this.rmqChannels.remove(h);
                }
            }
        }
    }

    public void updatePublishChannel() {
        if (this.getPublishRMQChannels().size() == 0) {
            try {
                PublishRMQChannel pubch = new PublishRMQChannel();
                pubch.addRMQChannelListener(this);
                pubch.open(this.connection);
                this.rmqChannels.add(pubch);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to open publish channel.", (Throwable)e);
            }
        }
    }

    @Override
    public void onOpen(AbstractRMQChannel rmqChannel) {
        if (rmqChannel instanceof ConsumeRMQChannel) {
            ConsumeRMQChannel consumeChannel = (ConsumeRMQChannel)rmqChannel;
            LOGGER.info("Open RabbitMQ channel #{} for {}.", (Object)rmqChannel.getChannel().getChannelNumber(), (Object)consumeChannel.getQueueName());
            consumeChannel.consume();
        } else if (rmqChannel instanceof PublishRMQChannel) {
            LOGGER.info("Open RabbitMQ channel #{} for publish.", (Object)rmqChannel.getChannel().getChannelNumber());
        }
    }

    @Override
    public void onCloseCompleted(AbstractRMQChannel rmqChannel) {
        if (this.rmqChannels.contains(rmqChannel)) {
            rmqChannel.removeRMQChannelListener(this);
            this.rmqChannels.remove(rmqChannel);
            try {
                if (rmqChannel instanceof ConsumeRMQChannel) {
                    ConsumeRMQChannel consumeChannel = (ConsumeRMQChannel)rmqChannel;
                    LOGGER.info("Closed RabbitMQ channel #{} for {}.", (Object)rmqChannel.getChannel().getChannelNumber(), (Object)consumeChannel.getQueueName());
                } else if (rmqChannel instanceof PublishRMQChannel) {
                    LOGGER.info("Closed RabbitMQ channel #{} for publish.", (Object)rmqChannel.getChannel().getChannelNumber());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addRMQConnectionListener(RMQConnectionListener rmqConnectionListener) {
        this.rmqConnectionListeners.add(rmqConnectionListener);
    }

    @Override
    public void removeRMQConnectionListener(RMQConnectionListener rmqConnectionListener) {
        this.rmqConnectionListeners.remove(rmqConnectionListener);
    }

    @Override
    public boolean isOpenRMQConnection() {
        return this.connection.isOpen();
    }

    @Override
    public void notifyRMQConnectionListeners(RMQConnectionEvent event) {
        for (RMQConnectionListener l : this.rmqConnectionListeners) {
            if (event == RMQConnectionEvent.CLOSE_COMPLETED) {
                l.onCloseCompleted(this);
                continue;
            }
            if (event != RMQConnectionEvent.OPEN) continue;
            l.onOpen(this);
        }
    }

    public void notifyOnCloseCompleted() {
        this.notifyRMQConnectionListeners(RMQConnectionEvent.CLOSE_COMPLETED);
    }

    public void notifyOnOpen() {
        this.notifyRMQConnectionListeners(RMQConnectionEvent.OPEN);
    }

    public void shutdownCompleted(ShutdownSignalException shutdownSignalException) {
        if (shutdownSignalException != null && !shutdownSignalException.isInitiatedByApplication()) {
            LOGGER.warn("RabbitMQ connection was suddenly disconnected.");
            ConnectionMonitor.get().setActivate(true);
        }
        this.state = RMQState.DISCONNECTED;
        this.closeAllChannels();
        this.notifyOnCloseCompleted();
        this.connection = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUri == null ? 0 : this.serviceUri.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.userPassword == null ? 0 : this.userPassword.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMQConnection other = (RMQConnection)obj;
        if (this.serviceUri == null ? other.serviceUri != null : !this.serviceUri.equals(other.serviceUri)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return !(this.userPassword == null ? other.userPassword != null : !this.userPassword.equals((Object)other.userPassword));
    }
}

