/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rabbitmqconsumer;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.jenkinsci.plugins.rabbitmqconsumer.Messages;
import org.jenkinsci.plugins.rabbitmqconsumer.RMQManager;
import org.jenkinsci.plugins.rabbitmqconsumer.RabbitmqConsumeItem;
import org.jenkinsci.plugins.rabbitmqconsumer.watchdog.ReconnectTimer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public final class GlobalRabbitmqConfiguration
extends GlobalConfiguration {
    private static final String PLUGIN_NAME = Messages.PluginName();
    public static final String CONTENT_NONE = "-";
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalRabbitmqConfiguration.class);
    private static final String[] AMQP_SCHEMES = new String[]{"amqp", "amqps"};
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(AMQP_SCHEMES, 8L);
    private boolean enableConsumer;
    private String serviceUri;
    private String userName;
    private Secret userPassword;
    private long watchdogPeriod = 60000L;
    private List<RabbitmqConsumeItem> consumeItems;
    private boolean enableDebug;

    @DataBoundConstructor
    public GlobalRabbitmqConfiguration(boolean enableConsumer, String serviceUri, String userName, Secret userPassword, long watchdogPeriod, List<RabbitmqConsumeItem> consumeItems, boolean enableDebug) {
        this.enableConsumer = enableConsumer;
        this.serviceUri = StringUtils.strip((String)StringUtils.stripToNull((String)serviceUri), (String)"/");
        this.userName = userName;
        this.userPassword = userPassword;
        this.watchdogPeriod = watchdogPeriod;
        this.consumeItems = consumeItems;
        this.enableDebug = enableDebug;
    }

    public GlobalRabbitmqConfiguration() {
        this.load();
    }

    public String getDisplayName() {
        return PLUGIN_NAME;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        if (this.consumeItems != null) {
            this.consumeItems.clear();
        }
        req.bindJSON((Object)this, json);
        ReconnectTimer timer = ReconnectTimer.get();
        if (timer != null) {
            timer.setRecurrencePeriod(this.watchdogPeriod);
        }
        if (URL_VALIDATOR.isValid(this.serviceUri)) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public boolean isEnableConsumer() {
        return this.enableConsumer;
    }

    public void setEnableConsumer(boolean enableConsumer) {
        this.enableConsumer = enableConsumer;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = StringUtils.strip((String)StringUtils.stripToNull((String)serviceUri), (String)"/");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Secret getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(Secret userPassword) {
        this.userPassword = userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = Secret.fromString((String)userPassword);
    }

    public long getWatchdogPeriod() {
        return this.watchdogPeriod;
    }

    public void setWatchdogPeriod(long watchdogPeriod) {
        this.watchdogPeriod = watchdogPeriod;
    }

    public FormValidation doCheckServiceUri(@QueryParameter String value) {
        String val = StringUtils.stripToNull((String)value);
        if (val == null) {
            return FormValidation.ok();
        }
        if (URL_VALIDATOR.isValid(val)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.InvalidURI());
    }

    public FormValidation doTestConnection(@QueryParameter(value="serviceUri") String serviceUri, @QueryParameter(value="userName") String userName, @QueryParameter(value="userPassword") Secret userPassword) throws ServletException {
        String uri = StringUtils.strip((String)StringUtils.stripToNull((String)serviceUri), (String)"/");
        if (uri != null && URL_VALIDATOR.isValid(uri)) {
            try {
                ConnectionFactory factory = new ConnectionFactory();
                factory.setUri(uri);
                if (StringUtils.isNotEmpty((CharSequence)userName)) {
                    factory.setUsername(userName);
                }
                if (StringUtils.isNotEmpty((CharSequence)Secret.toString((Secret)userPassword))) {
                    factory.setPassword(Secret.toString((Secret)userPassword));
                }
                factory.newConnection();
                return FormValidation.ok((String)Messages.Success());
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)Messages.InvalidURI());
            }
            catch (GeneralSecurityException e) {
                return FormValidation.error((String)(Messages.Error() + ": " + e));
            }
            catch (PossibleAuthenticationFailureException e) {
                return FormValidation.error((String)Messages.AuthFailure());
            }
            catch (IOException e) {
                return FormValidation.error((String)(Messages.Error() + ": " + e));
            }
        }
        return FormValidation.error((String)Messages.InvalidURI());
    }

    public List<RabbitmqConsumeItem> getConsumeItems() {
        return this.consumeItems;
    }

    public void setConsumeItems(List<RabbitmqConsumeItem> consumeItems) {
        this.consumeItems = consumeItems;
    }

    @JavaScriptMethod
    public boolean isOpen() {
        return RMQManager.getInstance().isOpen();
    }

    @JavaScriptMethod
    public boolean isConsume(String queueName) {
        RMQManager manager = RMQManager.getInstance();
        if (manager.isOpen()) {
            return manager.getChannelStatus(queueName);
        }
        return false;
    }

    public static GlobalRabbitmqConfiguration get() {
        return (GlobalRabbitmqConfiguration)((Object)GlobalConfiguration.all().get(GlobalRabbitmqConfiguration.class));
    }
}

