/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.sonar.api;

import hudson.util.Secret;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;

public class SonarInstanceValidationService {
    public String validateUrl(GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        String sonarUrl;
        if (globalConfigDataForSonarInstance.getSonarUrl().isEmpty()) {
            sonarUrl = "http://localhost:9000";
        } else {
            sonarUrl = globalConfigDataForSonarInstance.getSonarUrl();
            if (sonarUrl.endsWith("/")) {
                sonarUrl = sonarUrl.substring(0, sonarUrl.length() - 1);
            }
        }
        return sonarUrl;
    }

    public String validateUsername(GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        String sonarUsername = globalConfigDataForSonarInstance.getUsername().isEmpty() ? "admin" : globalConfigDataForSonarInstance.getUsername();
        return sonarUsername;
    }

    public Secret validatePassword(GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        String sonarPassword = globalConfigDataForSonarInstance.getPass().isEmpty() ? "admin" : globalConfigDataForSonarInstance.getPass();
        return Secret.fromString((String)sonarPassword);
    }

    public GlobalConfigDataForSonarInstance validateData(GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        return new GlobalConfigDataForSonarInstance(globalConfigDataForSonarInstance.getName(), this.validateUrl(globalConfigDataForSonarInstance), this.validateUsername(globalConfigDataForSonarInstance), this.validatePassword(globalConfigDataForSonarInstance));
    }
}

