/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.sonar.api;

import org.json.JSONException;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.QGException;
import quality.gates.sonar.api.QualityGateResponseParser;
import quality.gates.sonar.api.QualityGatesStatus;
import quality.gates.sonar.api.SonarHttpRequester;
import quality.gates.sonar.api.SonarInstanceValidationService;

public class QualityGatesProvider {
    private QualityGateResponseParser qualityGateResponseParser;
    private SonarHttpRequester sonarHttpRequester;
    private SonarInstanceValidationService sonarInstanceValidationService;

    public QualityGatesProvider() {
        this.qualityGateResponseParser = new QualityGateResponseParser();
        this.sonarHttpRequester = new SonarHttpRequester();
        this.sonarInstanceValidationService = new SonarInstanceValidationService();
    }

    public QualityGatesProvider(QualityGateResponseParser qualityGateResponseParser, SonarHttpRequester sonarHttpRequester, SonarInstanceValidationService sonarInstanceValidationService) {
        this.qualityGateResponseParser = qualityGateResponseParser;
        this.sonarHttpRequester = sonarHttpRequester;
        this.sonarInstanceValidationService = sonarInstanceValidationService;
    }

    public QualityGatesStatus getAPIResultsForQualityGates(JobConfigData jobConfigData, GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) throws JSONException {
        GlobalConfigDataForSonarInstance validatedData = this.sonarInstanceValidationService.validateData(globalConfigDataForSonarInstance);
        String requesterResult = this.getRequesterResult(jobConfigData, validatedData);
        return this.qualityGateResponseParser.getQualityGateResultFromJSON(requesterResult);
    }

    public String getRequesterResult(JobConfigData jobConfigData, GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) throws QGException {
        return this.sonarHttpRequester.getAPIInfo(jobConfigData, globalConfigDataForSonarInstance);
    }
}

