/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.sonar.api;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quality.gates.jenkins.plugin.QGException;
import quality.gates.sonar.api.QualityGatesStatus;

public class QualityGateResponseParser {
    public QualityGatesStatus getQualityGateResultFromJSON(String jsonString) throws QGException {
        JSONArray resultArray = this.createJSONArrayFromString(jsonString);
        JSONObject latestEventResult = this.getLatestEventResult(resultArray);
        String gateStatus = this.getValueForJSONKey(latestEventResult, "n");
        if (gateStatus.startsWith("Green")) {
            return new QualityGatesStatus("OK");
        }
        return new QualityGatesStatus("ERROR");
    }

    protected JSONObject getLatestEventResult(JSONArray jsonArray) throws QGException {
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        int jsonArrayLength = jsonArray.length();
        if (jsonArrayLength == 0) {
            jsonObjects.add(this.createObjectWithStatusGreen());
        } else {
            for (int i = 0; i < jsonArrayLength; ++i) {
                jsonObjects.add(this.getJSONObjectFromArray(jsonArray, i));
            }
        }
        String mostRecentAlertID = this.getValueForJSONKey(jsonObjects, 0, "id");
        JSONObject returnObject = (JSONObject)jsonObjects.get(0);
        for (int i = 0; i < jsonObjects.size(); ++i) {
            String alertId = this.getValueForJSONKey(jsonObjects, i, "id");
            if (Integer.parseInt(alertId) <= Integer.parseInt(mostRecentAlertID)) continue;
            returnObject = (JSONObject)jsonObjects.get(i);
        }
        return returnObject;
    }

    protected JSONObject createObjectWithStatusGreen() {
        try {
            JSONObject returnObject = new JSONObject();
            returnObject.put("id", (Object)"1");
            returnObject.put("dt", (Object)"2000-01-01T12:00:00+0100");
            returnObject.put("n", (Object)"Green");
            return returnObject;
        }
        catch (JSONException e) {
            throw new QGException(e);
        }
    }

    protected JSONObject getJSONObjectFromArray(JSONArray array, int index) throws QGException {
        try {
            return array.getJSONObject(index);
        }
        catch (JSONException e) {
            throw new QGException("The request returned an empty array", e);
        }
    }

    protected String getValueForJSONKey(List<JSONObject> array, int index, String key) throws QGException {
        try {
            return array.get(index).getString(key);
        }
        catch (JSONException e) {
            throw new QGException("JSON Key was not found", e);
        }
    }

    protected String getValueForJSONKey(JSONObject jsonObject, String key) throws QGException {
        try {
            return jsonObject.getString(key);
        }
        catch (JSONException e) {
            throw new QGException("JSON Key was not found ", e);
        }
    }

    protected JSONArray createJSONArrayFromString(String jsonString) throws QGException {
        try {
            return new JSONArray(jsonString);
        }
        catch (JSONException e) {
            throw new QGException("There was a problem handling the JSON response " + jsonString, e);
        }
    }
}

