/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.JobConfigurationService;
import quality.gates.jenkins.plugin.JobExecutionService;
import quality.gates.jenkins.plugin.QGBuilder;
import quality.gates.jenkins.plugin.QGException;

@Extension
public final class QGBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    @Inject
    private JobConfigurationService jobConfigurationService;
    @Inject
    private JobExecutionService jobExecutionService;

    public QGBuilderDescriptor() {
        super(QGBuilder.class);
        this.load();
    }

    public QGBuilderDescriptor(JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService) {
        super(QGBuilder.class);
        this.jobConfigurationService = jobConfigurationService;
        this.jobExecutionService = jobExecutionService;
    }

    public ListBoxModel doFillListOfGlobalConfigDataItems() {
        return this.jobConfigurationService.getListOfSonarInstanceNames(this.jobExecutionService.getGlobalConfigData());
    }

    public FormValidation doCheckProjectKey(@QueryParameter String projectKey) {
        if (projectKey.isEmpty()) {
            return FormValidation.error((String)"Please insert project key.");
        }
        return FormValidation.ok();
    }

    public String getDisplayName() {
        return "Quality Gates";
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
        this.save();
        return true;
    }

    public QGBuilder newInstance(StaplerRequest req, JSONObject formData) throws QGException {
        JobConfigData firstInstanceJobConfigData = this.jobConfigurationService.createJobConfigData(formData, this.jobExecutionService.getGlobalConfigData());
        return new QGBuilder(firstInstanceJobConfigData);
    }
}

