/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Util;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;

public class GlobalConfigurationService {
    private List<GlobalConfigDataForSonarInstance> listOfGlobalConfigInstances;

    public void setListOfGlobalConfigInstances(List<GlobalConfigDataForSonarInstance> listOfGlobalConfigInstances) {
        this.listOfGlobalConfigInstances = listOfGlobalConfigInstances;
    }

    protected List<GlobalConfigDataForSonarInstance> instantiateGlobalConfigData(JSONObject json) {
        this.listOfGlobalConfigInstances = new ArrayList<GlobalConfigDataForSonarInstance>();
        JSON globalDataConfigs = (JSON)json.opt("listOfGlobalConfigData");
        if (globalDataConfigs == null) {
            globalDataConfigs = new JSONArray();
        }
        this.initGlobalDataConfig(globalDataConfigs);
        return this.listOfGlobalConfigInstances;
    }

    protected void initGlobalDataConfig(JSON globalDataConfigs) {
        JSONArray array = this.getGlobalConfigsArray(globalDataConfigs);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonobject = array.getJSONObject(i);
            this.addGlobalConfigDataForSonarInstance(jsonobject);
        }
    }

    protected JSONArray getGlobalConfigsArray(JSON globalDataConfigs) {
        JSONArray array = globalDataConfigs.isArray() ? (JSONArray)JSONArray.class.cast(globalDataConfigs) : this.createJsonArrayFromObject((JSONObject)globalDataConfigs);
        return array;
    }

    protected JSONArray createJsonArrayFromObject(JSONObject globalDataConfigs) {
        JSONArray array = new JSONArray();
        array.add((Object)globalDataConfigs);
        return array;
    }

    protected void addGlobalConfigDataForSonarInstance(JSONObject globalConfigData) {
        String name = globalConfigData.optString("name");
        if (!"".equals(name)) {
            GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance = new GlobalConfigDataForSonarInstance(name, globalConfigData.optString("url"), globalConfigData.optString("account"), Secret.fromString((String)Util.fixEmptyAndTrim((String)globalConfigData.optString("password"))));
            if (!this.containsGlobalConfigWithName(name)) {
                this.listOfGlobalConfigInstances.add(globalConfigDataForSonarInstance);
            }
        }
    }

    protected boolean containsGlobalConfigWithName(String name) {
        for (GlobalConfigDataForSonarInstance globalConfigDataInstance : this.listOfGlobalConfigInstances) {
            if (!globalConfigDataInstance.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

