/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.GlobalConfigurationService;

@Extension
public class GlobalConfig
extends GlobalConfiguration {
    private List<GlobalConfigDataForSonarInstance> listOfGlobalConfigData;
    private GlobalConfigurationService globalConfigurationService;

    public GlobalConfig() {
        this.load();
        this.globalConfigurationService = new GlobalConfigurationService();
    }

    public GlobalConfig(List<GlobalConfigDataForSonarInstance> listOfGlobalConfigData, GlobalConfigurationService globalConfigurationService) {
        this.listOfGlobalConfigData = listOfGlobalConfigData;
        this.globalConfigurationService = globalConfigurationService;
    }

    public List<GlobalConfigDataForSonarInstance> getListOfGlobalConfigData() {
        this.load();
        return this.listOfGlobalConfigData;
    }

    public List<GlobalConfigDataForSonarInstance> fetchListOfGlobalConfigData() {
        return this.listOfGlobalConfigData;
    }

    public void setGlobalConfigDataForSonarInstances(List<GlobalConfigDataForSonarInstance> globalConfigDataForSonarInstances) {
        this.listOfGlobalConfigData = globalConfigDataForSonarInstances;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.listOfGlobalConfigData = this.globalConfigurationService.instantiateGlobalConfigData(json);
        this.save();
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String name) {
        if (name.isEmpty()) {
            return FormValidation.error((String)"Please insert a name for the instance.");
        }
        return FormValidation.ok();
    }

    public GlobalConfigDataForSonarInstance getSonarInstanceByName(String name) {
        for (GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance : this.listOfGlobalConfigData) {
            if (!name.equals(globalConfigDataForSonarInstance.getName())) continue;
            return globalConfigDataForSonarInstance;
        }
        return null;
    }
}

