/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import jenkins.plugins.publish_over_ssh.BapSshTransferCacheRow;
import org.jenkinsci.remoting.RoleChecker;

public class BapSshTransferCache {
    private static final String CACHEFILENAME = "remoteResourceCache.json";
    private HashMap<String, BapSshTransferCacheRow> data;
    private File configFile;
    private FilePath.FileCallable<File> callableFile;

    public BapSshTransferCache(FilePath configPath) {
        try {
            this.callableFile = new FilePath.FileCallable<File>(){

                public File invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                    return file;
                }

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }
            };
            this.configFile = (File)configPath.child(CACHEFILENAME).act(this.callableFile);
            ObjectMapper mapper = new ObjectMapper();
            this.data = (HashMap)mapper.readValue(this.configFile, (TypeReference)new TypeReference<HashMap<String, BapSshTransferCacheRow>>(){});
        }
        catch (IOException | InterruptedException ex) {
            this.data = new HashMap();
        }
    }

    public void save() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(this.configFile, this.data);
        }
        catch (IOException ex) {
            this.data = null;
        }
    }

    public boolean checkCachedResource(FilePath filePath) {
        try {
            File resource = (File)filePath.act(this.callableFile);
            if (!this.data.containsKey(resource.getAbsolutePath())) {
                this.data.put(resource.getAbsolutePath(), new BapSshTransferCacheRow(resource));
                return true;
            }
            BapSshTransferCacheRow resourceEntry = this.data.get(resource.getAbsolutePath());
            return resourceEntry.mustUpdateWith(resource);
        }
        catch (IOException | InterruptedException ex) {
            this.data = new HashMap();
            this.configFile = new File(CACHEFILENAME);
            return false;
        }
    }
}

