/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPDefaultClient;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_ssh.BapSshTransfer;
import jenkins.plugins.publish_over_ssh.BapSshTransferCache;
import jenkins.plugins.publish_over_ssh.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BapSshClient
extends BPDefaultClient<BapSshTransfer> {
    private static final transient Log LOG = LogFactory.getLog(BapSshClient.class);
    private final BPBuildInfo buildInfo;
    private final Stack<Session> sessions = new Stack();
    private final boolean disableExec;
    private ChannelSftp sftp;
    private final boolean avoidSameFileUpload;
    private BapSshTransferCache remoteResourceCache;

    public BapSshClient(BPBuildInfo buildInfo, Session session) {
        this(buildInfo, session, false, false);
    }

    public BapSshClient(BPBuildInfo buildInfo, Session session, boolean disableExec, boolean avoidSameFileUpload) {
        this.buildInfo = buildInfo;
        this.disableExec = disableExec;
        this.avoidSameFileUpload = avoidSameFileUpload;
        this.addSession(session);
    }

    public void addSession(Session session) {
        this.sessions.push(session);
    }

    public boolean isDisableExec() {
        return this.disableExec;
    }

    public boolean isAvoidSameFileUpload() {
        return this.avoidSameFileUpload;
    }

    public BPBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public Session getSession() {
        return this.sessions.peek();
    }

    public void beginTransfers(BapSshTransfer transfer) {
        if (this.disableExec) {
            if (!transfer.hasConfiguredSourceFiles()) {
                throw new BapPublisherException(Messages.exception_badTransferConfig_noExec());
            }
        } else if (!transfer.hasConfiguredSourceFiles() && !transfer.hasExecCommand()) {
            throw new BapPublisherException(Messages.exception_badTransferConfig());
        }
        BPBuildEnv buildEnv = this.getBuildInfo().getCurrentBuildEnv();
        String jobName = (String)buildEnv.getEnvVars().get("JOB_NAME");
        FilePath jobConfigPath = this.getBuildInfo().getConfigDir().child("jobs").child(jobName);
        if (this.isAvoidSameFileUpload()) {
            this.remoteResourceCache = new BapSshTransferCache(jobConfigPath);
        }
    }

    public boolean changeDirectory(String directory) {
        try {
            if (!this.sftp.stat(directory).isDir()) {
                return false;
            }
        }
        catch (SftpException sftpe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.log_sftp_stat(directory, sftpe.getLocalizedMessage()));
            }
            return false;
        }
        try {
            this.buildInfo.printIfVerbose(Messages.console_cd(directory));
            this.sftp.cd(directory);
            this.success();
            return true;
        }
        catch (SftpException sftpe) {
            throw new BapPublisherException(Messages.exception_cwdException(directory, sftpe.getLocalizedMessage()), (Throwable)sftpe);
        }
    }

    public void deleteTree() throws SftpException {
        this.delete();
    }

    private void delete() throws SftpException {
        Vector fileAndFolderList = this.sftp.ls(this.sftp.pwd());
        for (ChannelSftp.LsEntry item : fileAndFolderList) {
            this.delete(item);
        }
    }

    private void delete(ChannelSftp.LsEntry entry) throws SftpException {
        if (entry == null) {
            throw new BapPublisherException(Messages.exception_client_entryIsNull());
        }
        String entryName = entry.getFilename();
        if (".".equals(entryName) || "..".equals(entryName)) {
            return;
        }
        if (entry.getAttrs().isDir()) {
            if (!this.changeDirectory(entryName)) {
                throw new BapPublisherException(Messages.exception_cwdException(entryName, "Error occurred changing directory"));
            }
            this.delete();
            if (!this.changeDirectory("..")) {
                throw new BapPublisherException(Messages.exception_client_cdup());
            }
            try {
                this.sftp.rmdir(entryName);
            }
            catch (SftpException e) {
                throw new BapPublisherException(Messages.exception_client_rmdir(entryName));
            }
        }
        try {
            this.sftp.rm(entryName);
        }
        catch (SftpException e) {
            throw new BapPublisherException(Messages.exception_client_dele(entryName));
        }
    }

    public boolean makeDirectory(String directory) {
        if (this.hasSubDirs(directory)) {
            return false;
        }
        try {
            this.buildInfo.printIfVerbose(Messages.console_mkdir(directory));
            this.sftp.mkdir(directory);
            this.success();
            return true;
        }
        catch (SftpException sftpe) {
            this.buildInfo.printIfVerbose(Messages.console_failure(sftpe.getLocalizedMessage()));
            return false;
        }
    }

    public void transferFile(BapSshTransfer bapSshTransfer, FilePath filePath, InputStream inputStream) throws SftpException, IOException, InterruptedException {
        FilePath parentFle;
        String fileName = filePath.getName();
        this.buildInfo.printIfVerbose(Messages.console_put(fileName));
        this.sftp.put(inputStream, fileName);
        if (bapSshTransfer.isKeepFilePermissions() && (parentFle = filePath.getParent()) != null) {
            int fileMode;
            FilePath directory = parentFle.absolutize();
            String remoteDir = this.sftp.pwd();
            int directoryMode = directory.mode();
            if (directoryMode >= 0) {
                this.buildInfo.printIfVerbose(Messages.console_chmod(Integer.toString(directoryMode, 8), fileName));
                this.sftp.chmod(directoryMode, remoteDir);
                this.success();
            }
            if ((fileMode = filePath.mode()) >= 0) {
                this.buildInfo.printIfVerbose(Messages.console_chmod(Integer.toString(fileMode, 8), fileName));
                this.sftp.chmod(fileMode, fileName);
                this.success();
            }
        }
    }

    private void success() {
        this.buildInfo.printIfVerbose(Messages.console_success());
    }

    private boolean hasSubDirs(String directory) {
        return directory.contains("/") || directory.contains("\\");
    }

    public void endTransfers(BapSshTransfer transfer) {
        if (this.isAvoidSameFileUpload()) {
            this.remoteResourceCache.save();
            this.remoteResourceCache = null;
        }
        if (!this.disableExec && transfer.hasExecCommand()) {
            if (transfer.isUseSftpForExec()) {
                this.sftpExec(transfer);
            } else {
                this.exec(transfer);
            }
        }
    }

    private void makeSymlink(String oldPath, String newPath) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_symlink(oldPath, newPath));
            this.sftp.symlink(oldPath, newPath);
            this.success();
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
        }
    }

    private void makeHardlink(String oldPath, String newPath) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_hardlink(oldPath, newPath));
            this.sftp.hardlink(oldPath, newPath);
            this.success();
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
        }
    }

    private void deleteDirectory(String pathName) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_deleteDirectory(pathName));
            this.sftp.rmdir(pathName);
            this.success();
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
        }
    }

    private void deleteFile(String pathName) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_deleteFile(pathName));
            this.sftp.rm(pathName);
            this.success();
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
        }
    }

    private void getDirContent(List<String> commandArguments) {
        boolean withAttrs = false;
        try {
            Vector fileAndDirectoryList;
            this.buildInfo.println(Messages.sftpExec_ls(String.join((CharSequence)" ", commandArguments)));
            String currentDir = this.sftp.pwd();
            if (!commandArguments.isEmpty()) {
                withAttrs = commandArguments.get(0).equals("-l");
                if (withAttrs) {
                    commandArguments.remove(0);
                }
                if (!commandArguments.isEmpty()) {
                    currentDir = commandArguments.get(0);
                }
            }
            if ((fileAndDirectoryList = this.sftp.ls(currentDir)).isEmpty()) {
                this.buildInfo.println(Messages.sftpExec_lsEmpty(currentDir));
            } else {
                this.showDirContent(this.sftp.ls(currentDir), withAttrs);
            }
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.sftpExec_failedCommand("ls"));
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
        }
    }

    private void showDirContent(Vector<ChannelSftp.LsEntry> entry, boolean withAttrs) {
        for (ChannelSftp.LsEntry item : entry) {
            if (item.getFilename().equals(".") || item.getFilename().equals("..")) continue;
            String getName = withAttrs ? item.getLongname() : item.getFilename();
            this.buildInfo.println(Messages.sftpExec_display(getName));
        }
        this.success();
    }

    private String parsePathName(String pathName, boolean isDir) {
        if (((String)pathName).contains("*") || ((String)pathName).contains("?")) {
            pathName = ((String)pathName).length() > 1 && ((String)pathName).contains("/") ? ((String)pathName).substring(0, ((String)pathName).lastIndexOf(47) + 1) : "./";
        }
        if (isDir && ((String)pathName).charAt(((String)pathName).length() - 1) != '/') {
            pathName = (String)pathName + "/";
        }
        return pathName;
    }

    private String parsePathName(String pathName) {
        return this.parsePathName(pathName, true);
    }

    private boolean changeLocalBaseDirectory(String newBaseDir) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_lcd(newBaseDir));
            this.sftp.lcd(newBaseDir);
            this.success();
            return true;
        }
        catch (SftpException sftpe) {
            this.buildInfo.println(Messages.console_failure(sftpe.getLocalizedMessage()));
            return false;
        }
    }

    private void getFiles(List<String> commandArguments) {
        String workspace = this.buildInfo.getBaseDirectory().getRemote();
        this.buildInfo.println(Messages.sftpExec_get(String.join((CharSequence)" ", commandArguments)));
        if (commandArguments.isEmpty() || commandArguments.size() == 1 && commandArguments.get(0).equals("-r")) {
            this.buildInfo.println(Messages.sftpExec_getArgumentsEmpty());
            return;
        }
        boolean isRecursive = commandArguments.get(0).equals("-r");
        if (isRecursive) {
            commandArguments.remove(0);
        }
        if (commandArguments.size() > 1 && this.changeLocalBaseDirectory(workspace) && this.changeLocalBaseDirectory(commandArguments.get(1))) {
            workspace = this.sftp.lpwd();
        }
        this.getFileList(commandArguments.get(0), workspace, isRecursive);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void getFileList(String remotePathName, String localBaseDir, boolean isRecursive) {
        try {
            this.buildInfo.printIfVerbose(Messages.sftpExec_baseDir(localBaseDir));
            this.buildInfo.printIfVerbose(Messages.sftpExec_showRemotePath(remotePathName));
            Vector fileAndDirectoryList = this.sftp.ls(remotePathName);
            if (fileAndDirectoryList.isEmpty()) {
                this.buildInfo.println(Messages.sftpExec_getEmpty(remotePathName));
                return;
            }
            for (ChannelSftp.LsEntry item : fileAndDirectoryList) {
                String itemFileName = item.getFilename();
                if (itemFileName.equals(".") || itemFileName.equals("..")) continue;
                if (!item.getAttrs().isDir()) {
                    this.getFile(itemFileName, this.parsePathName(remotePathName, false), localBaseDir);
                    continue;
                }
                if (isRecursive) {
                    File newFile = new File(localBaseDir, itemFileName);
                    newFile.mkdir();
                    this.getFileList(this.parsePathName(remotePathName, true) + itemFileName + "/", localBaseDir + "/" + itemFileName, true);
                    continue;
                }
                this.buildInfo.printIfVerbose(Messages.sftpExec_isDirectory(itemFileName));
            }
        }
        catch (SftpException | IOException e) {
            this.buildInfo.println(Messages.sftpExec_failedCommand("get"));
            this.buildInfo.println(Messages.console_failure(e.getLocalizedMessage()));
        }
    }

    private void getFile(String fileName, String remotePathName, String localBaseDir) throws SftpException, IOException {
        this.buildInfo.println(Messages.sftpExec_getFile(fileName));
        try (FileOutputStream outputStream = new FileOutputStream(new File(localBaseDir, fileName));){
            if (!fileName.equals(remotePathName.substring(remotePathName.lastIndexOf(47) + 1))) {
                this.sftp.get(this.parsePathName(remotePathName) + fileName, (OutputStream)outputStream);
            } else {
                this.sftp.get(remotePathName, (OutputStream)outputStream);
            }
            this.success();
        }
    }

    public String[] parseAllCommands(BapSshTransfer transfer) {
        return Util.replaceMacro((String)transfer.getExecCommand(), (Map)this.buildInfo.getEnvVars()).split("\n\\s*");
    }

    public String[] parseCommand(String command) {
        return command.trim().split("\\s+");
    }

    private void sftpExec(BapSshTransfer transfer) {
        this.changeDirectory(this.getAbsoluteRemoteRoot());
        for (String commandToken : this.parseAllCommands(transfer)) {
            String[] command = this.parseCommand(commandToken);
            try {
                switch (command[0]) {
                    case "cd": {
                        this.changeDirectory(command[1]);
                        break;
                    }
                    case "symlink": {
                        this.makeSymlink(command[1], command[2]);
                        break;
                    }
                    case "mkdir": {
                        this.makeDirectory(command[1]);
                        break;
                    }
                    case "rm": {
                        this.deleteFile(command[1]);
                        break;
                    }
                    case "rmdir": {
                        this.deleteDirectory(command[1]);
                        break;
                    }
                    case "ln": {
                        if (command[1].equals("-s")) {
                            this.makeSymlink(command[2], command[3]);
                            break;
                        }
                        this.makeHardlink(command[1], command[2]);
                        break;
                    }
                    case "ls": {
                        int maxSize = command.length > 3 ? 3 : command.length;
                        this.getDirContent(new ArrayList<String>(Arrays.asList(command).subList(1, maxSize)));
                        break;
                    }
                    case "get": {
                        int maxSize = command.length > 4 ? 4 : command.length;
                        this.getFiles(new ArrayList<String>(Arrays.asList(command).subList(1, maxSize)));
                        break;
                    }
                    default: {
                        this.buildInfo.println(Messages.sftpExec_unsupportedCommand(command[0]));
                        break;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.buildInfo.println(Messages.sftpExec_tooFewArguments(command[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(BapSshTransfer transfer) {
        ChannelExec exec = null;
        try {
            exec = this.openExecChannel();
            exec.setPty(transfer.isUsePty());
            exec.setAgentForwarding(transfer.isUseAgentForwarding());
            exec.setInputStream(null);
            if (this.buildInfo.isVerbose()) {
                exec.setOutputStream((OutputStream)this.buildInfo.getListener().getLogger(), true);
                exec.setErrStream((OutputStream)this.buildInfo.getListener().getLogger(), true);
            }
            this.connectExecChannel(exec, Util.replaceMacro((String)transfer.getExecCommand(), (Map)this.buildInfo.getEnvVars()));
            this.waitForExec(exec, transfer.getExecTimeout());
            int status = exec.getExitStatus();
            if (status != 0) {
                throw new BapPublisherException(Messages.exception_exec_exitStatus(status));
            }
        }
        finally {
            this.disconnectExecQuietly(exec);
        }
    }

    private void connectExecChannel(ChannelExec exec, String command) {
        exec.setCommand(command);
        this.buildInfo.printIfVerbose(Messages.console_exec_connecting(command));
        try {
            exec.connect(this.getSession().getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_exec_connect(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
        this.buildInfo.printIfVerbose(Messages.console_exec_connected());
    }

    private ChannelExec openExecChannel() {
        this.buildInfo.printIfVerbose(Messages.console_exec_opening());
        try {
            ChannelExec exec = (ChannelExec)this.getSession().openChannel("exec");
            this.buildInfo.printIfVerbose(Messages.console_exec_opened());
            return exec;
        }
        catch (JSchException jse) {
            String message = Messages.exception_exec_open(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
    }

    public void disconnectExecQuietly(ChannelExec exec) {
        try {
            this.disconnectExec(exec);
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_exec(e.getLocalizedMessage()));
        }
    }

    private void disconnectExec(ChannelExec exec) {
        if (exec == null) {
            return;
        }
        if (exec.isConnected()) {
            exec.disconnect();
        }
    }

    public void disconnect() {
        this.disconnectSftp();
        this.disconnectSession();
    }

    private void disconnectSftp() {
        if (this.sftp == null) {
            return;
        }
        if (this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
    }

    private void disconnectSession() {
        while (!this.sessions.empty()) {
            Session session = this.sessions.pop();
            if (!session.isConnected()) continue;
            session.disconnect();
        }
    }

    public void disconnectQuietly() {
        try {
            this.disconnectSftp();
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_sftp(e.getLocalizedMessage()));
        }
        try {
            this.disconnectSession();
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_session(e.getLocalizedMessage()));
        }
    }

    private void waitForExec(ChannelExec exec, long timeout) {
        long start = System.currentTimeMillis();
        ExecCheckThread waiter = new ExecCheckThread(exec);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException ie) {
            waiter.interrupt();
            LOG.warn((Object)ie.getMessage(), (Throwable)ie);
        }
        long duration = System.currentTimeMillis() - start;
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        if (!exec.isClosed()) {
            throw new BapPublisherException(Messages.exception_exec_timeout(duration));
        }
        this.buildInfo.println(Messages.console_exec_completed(duration));
    }

    private static final class ExecCheckThread
    extends Thread {
        private static final int POLL_TIME = 200;
        private final ChannelExec exec;

        ExecCheckThread(ChannelExec exec) {
            this.exec = exec;
        }

        @Override
        public void run() {
            try {
                while (!this.exec.isClosed()) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ie) {
                this.interrupt();
                LOG.warn((Object)ie.getMessage(), (Throwable)ie);
            }
        }
    }
}

