/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.descriptor;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.util.Collection;
import java.util.List;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPPluginDescriptor;
import jenkins.plugins.publish_over.JenkinsCapabilities;
import jenkins.plugins.publish_over_ssh.BapSshCommonConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.BapSshSftpSetupException;
import jenkins.plugins.publish_over_ssh.Messages;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshHostConfigurationDescriptor;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshPublisherDescriptor;
import jenkins.plugins.publish_over_ssh.options.SshDefaults;
import jenkins.plugins.publish_over_ssh.options.SshPluginDefaults;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshPublisherPluginDescriptor
extends BuildStepDescriptor<Publisher> {
    private BPPluginDescriptor.BPDescriptorMessages msg;
    private Class commonConfigClass;
    private Class hostConfigClass;
    private final CopyOnWriteList<BapSshHostConfiguration> hostConfigurations = new CopyOnWriteList();
    private BapSshCommonConfiguration commonConfig;
    private SshDefaults defaults;

    public BapSshPublisherPluginDescriptor() {
        super(BapSshPublisherPlugin.class);
        this.load();
        if (this.defaults == null) {
            this.defaults = new SshPluginDefaults();
        }
    }

    public BapSshCommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }

    public void setCommonConfig(BapSshCommonConfiguration commonConfig) {
        this.commonConfig = commonConfig;
    }

    public SshDefaults getDefaults() {
        return this.defaults;
    }

    public String getDisplayName() {
        return Messages.descriptor_displayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
    }

    public List<BapSshHostConfiguration> getHostConfigurations() {
        return this.hostConfigurations.getView();
    }

    public BapSshHostConfiguration getConfiguration(String name) {
        for (BapSshHostConfiguration configuration : this.hostConfigurations) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    public boolean configure(StaplerRequest request, JSONObject formData) {
        List newConfigurations = request.bindJSONToList(BapSshHostConfiguration.class, formData.get("instance"));
        this.commonConfig = (BapSshCommonConfiguration)request.bindJSON(BapSshCommonConfiguration.class, formData.getJSONObject("commonConfig"));
        for (BapSshHostConfiguration hostConfig : newConfigurations) {
            hostConfig.setCommonConfig(this.commonConfig);
        }
        this.hostConfigurations.replaceBy((Collection)newConfigurations);
        if (this.isEnableOverrideDefaults()) {
            this.defaults = (SshDefaults)request.bindJSON(SshDefaults.class, formData.getJSONObject("defaults"));
        }
        this.save();
        return true;
    }

    public boolean canSetMasterNodeName() {
        return JenkinsCapabilities.missing((VersionNumber)JenkinsCapabilities.MASTER_HAS_NODE_NAME);
    }

    public String getDefaultMasterNodeName() {
        return "master";
    }

    public boolean isEnableOverrideDefaults() {
        return JenkinsCapabilities.available((VersionNumber)JenkinsCapabilities.SIMPLE_DESCRIPTOR_SELECTOR);
    }

    public BapSshPublisherDescriptor getPublisherDescriptor() {
        return (BapSshPublisherDescriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherDescriptor.class);
    }

    public BapSshHostConfigurationDescriptor getHostConfigurationDescriptor() {
        return (BapSshHostConfigurationDescriptor)Hudson.getInstance().getDescriptorByType(BapSshHostConfigurationDescriptor.class);
    }

    public SshPluginDefaults.SshPluginDefaultsDescriptor getPluginDefaultsDescriptor() {
        return (SshPluginDefaults.SshPluginDefaultsDescriptor)Hudson.getInstance().getDescriptorByType(SshPluginDefaults.SshPluginDefaultsDescriptor.class);
    }

    public jenkins.plugins.publish_over.view_defaults.BPInstanceConfig.Messages getCommonFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.BPInstanceConfig.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages getCommonManageMessages() {
        return new jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages();
    }

    public FormValidation doTestConnection(StaplerRequest request, StaplerResponse response) {
        BapSshHostConfiguration hostConfig = (BapSshHostConfiguration)((Object)request.bindParameters(BapSshHostConfiguration.class, ""));
        hostConfig.setCommonConfig(request.bindParameters(BapSshCommonConfiguration.class, "common."));
        BPBuildInfo buildInfo = this.createDummyBuildInfo();
        try {
            hostConfig.createClient(buildInfo).disconnect();
            return FormValidation.ok((String)Messages.descriptor_testConnection_ok());
        }
        catch (BapSshSftpSetupException sse) {
            return this.connectionError(Messages.descriptor_testConnection_sftpError(), (Exception)((Object)sse));
        }
        catch (Exception e) {
            return this.connectionError(Messages.descriptor_testConnection_error(), e);
        }
    }

    private FormValidation connectionError(String description, Exception exception) {
        return FormValidation.errorWithMarkup((String)("<p>" + description + "</p><p><pre>" + Util.escape((String)(exception.getClass().getCanonicalName() + ": " + exception.getLocalizedMessage())) + "</pre></p>"));
    }

    private BPBuildInfo createDummyBuildInfo() {
        return new BPBuildInfo(TaskListener.NULL, "", Hudson.getInstance().getRootPath(), null, null);
    }

    public Object readResolve() {
        this.msg = null;
        this.commonConfigClass = null;
        this.hostConfigClass = null;
        if (this.defaults == null) {
            this.defaults = new SshPluginDefaults();
        }
        return this;
    }
}

