/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.options;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over.view_defaults.BPTransfer.Messages;
import jenkins.plugins.publish_over_ssh.options.SshTransferOptions;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshOverrideTransferDefaults
implements SshTransferOptions,
Describable<SshOverrideTransferDefaults> {
    private final String execCommand;
    private final int execTimeout;
    private final String sourceFiles;
    private final String removePrefix;
    private final String remoteDirectory;
    private final String excludes;
    private final boolean remoteDirectorySDF;
    private final boolean flatten;
    private final boolean cleanRemote;

    @DataBoundConstructor
    public SshOverrideTransferDefaults(String sourceFiles, String excludes, String removePrefix, String remoteDirectory, boolean flatten, boolean remoteDirectorySDF, boolean cleanRemote, String execCommand, int execTimeout) {
        this.cleanRemote = cleanRemote;
        this.excludes = excludes;
        this.execCommand = execCommand;
        this.execTimeout = execTimeout;
        this.flatten = flatten;
        this.remoteDirectory = remoteDirectory;
        this.remoteDirectorySDF = remoteDirectorySDF;
        this.removePrefix = removePrefix;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public String getExecCommand() {
        return this.execCommand;
    }

    @Override
    public int getExecTimeout() {
        return this.execTimeout;
    }

    public String getSourceFiles() {
        return this.sourceFiles;
    }

    public String getRemovePrefix() {
        return this.removePrefix;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean isRemoteDirectorySDF() {
        return this.remoteDirectorySDF;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isCleanRemote() {
        return this.cleanRemote;
    }

    public SshOverrideTransferDefaultsDescriptor getDescriptor() {
        return (SshOverrideTransferDefaultsDescriptor)Hudson.getInstance().getDescriptorByType(SshOverrideTransferDefaultsDescriptor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class SshOverrideTransferDefaultsDescriptor
    extends Descriptor<SshOverrideTransferDefaults> {
        public String getDisplayName() {
            return "SshOverrideTransferDefaultsDescriptor - not visible ...";
        }

        public boolean canUseExcludes() {
            return BPTransfer.canUseExcludes();
        }

        public FormValidation doCheckExecTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public Messages getCommonFieldNames() {
            return new Messages();
        }
    }
}

