/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.descriptor;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.view_defaults.HostConfiguration.Messages;
import jenkins.plugins.publish_over_ssh.BapSshCredentials;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshPublisherPluginDescriptor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

@Extension
public class BapSshCredentialsDescriptor
extends Descriptor<BapSshCredentials> {
    public BapSshCredentialsDescriptor() {
        super(BapSshCredentials.class);
    }

    public String getDisplayName() {
        return "not seen";
    }

    public FormValidation doCheckUsername(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckKeyPath(@QueryParameter String value) {
        AccessControlled subject = (AccessControlled)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        if (subject == null) {
            subject = Jenkins.getInstance();
        }
        if (!subject.hasPermission(Item.CONFIGURE) && subject.hasPermission(Item.EXTENDED_READ)) {
            return FormValidation.ok();
        }
        try {
            return Jenkins.getInstance().getRootPath().validateRelativePath(value, true, true);
        }
        catch (IOException ioe) {
            return FormValidation.error((Throwable)ioe, (String)"");
        }
        catch (NullPointerException npe) {
            return FormValidation.error((Throwable)npe, (String)"");
        }
    }

    public FormValidation doTestConnection(@QueryParameter String configName, @QueryParameter String username, @QueryParameter String encryptedPassphrase, @QueryParameter String key, @QueryParameter String keyPath) {
        BapSshCredentials credentials = new BapSshCredentials(username, encryptedPassphrase, key, keyPath);
        BPBuildInfo buildInfo = BapSshPublisherPluginDescriptor.createDummyBuildInfo();
        buildInfo.put("credentials", (Serializable)credentials);
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            throw new NullPointerException("Jenkins is not ready on going to be offline...");
        }
        BapSshPublisherPlugin.Descriptor pluginDescriptor = (BapSshPublisherPlugin.Descriptor)j.getDescriptorByType(BapSshPublisherPlugin.Descriptor.class);
        BapSshHostConfiguration hostConfig = pluginDescriptor.getConfiguration(configName);
        return BapSshPublisherPluginDescriptor.validateConnection(hostConfig, buildInfo);
    }

    public Messages getCommonFieldNames() {
        return new Messages();
    }
}

