/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Util;
import hudson.model.Describable;
import hudson.model.Hudson;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshTransferDescriptor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshTransfer
extends BPTransfer
implements Describable<BapSshTransfer> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_EXEC_TIMEOUT = 120000;
    private String execCommand;
    private int execTimeout;

    BapSshTransfer(String sourceFiles, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        this(sourceFiles, null, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, execCommand, execTimeout);
    }

    @DataBoundConstructor
    public BapSshTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        super(sourceFiles, excludes, remoteDirectory, removePrefix, remoteDirectorySDF, flatten);
        this.execCommand = execCommand;
        this.execTimeout = execTimeout;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public int getExecTimeout() {
        return this.execTimeout;
    }

    public boolean hasExecCommand() {
        return Util.fixEmptyAndTrim((String)this.getExecCommand()) != null;
    }

    public BapSshTransferDescriptor getDescriptor() {
        return (BapSshTransferDescriptor)Hudson.getInstance().getDescriptorByType(BapSshTransferDescriptor.class);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append((Object)this.execCommand).append(this.execTimeout);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapSshTransfer that) {
        return super.addToEquals(builder, (BPTransfer)that).append((Object)this.execCommand, (Object)that.execCommand).append(this.execTimeout, that.execTimeout);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("execCommand", (Object)this.execCommand).append("execTimeout", this.execTimeout);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BapSshTransfer)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

