/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.descriptor;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.util.Collection;
import java.util.List;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPPluginDescriptor;
import jenkins.plugins.publish_over_ssh.BapSshCommonConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.Messages;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshHostConfigurationDescriptor;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshPublisherDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshPublisherPluginDescriptor
extends BuildStepDescriptor<Publisher> {
    private BPPluginDescriptor.BPDescriptorMessages msg;
    private Class commonConfigClass;
    private Class hostConfigClass;
    private final CopyOnWriteList<BapSshHostConfiguration> hostConfigurations = new CopyOnWriteList();
    private BapSshCommonConfiguration commonConfig;

    public BapSshPublisherPluginDescriptor() {
        super(BapSshPublisherPlugin.class);
        this.load();
    }

    public BapSshCommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }

    public void setCommonConfig(BapSshCommonConfiguration commonConfig) {
        this.commonConfig = commonConfig;
    }

    public String getDisplayName() {
        return Messages.descriptor_displayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
    }

    public List<BapSshHostConfiguration> getHostConfigurations() {
        return this.hostConfigurations.getView();
    }

    public BapSshHostConfiguration getConfiguration(String name) {
        for (BapSshHostConfiguration configuration : this.hostConfigurations) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    public boolean configure(StaplerRequest request, JSONObject formData) {
        List newConfigurations = request.bindJSONToList(BapSshHostConfiguration.class, formData.get("instance"));
        this.commonConfig = (BapSshCommonConfiguration)request.bindJSON(BapSshCommonConfiguration.class, formData.getJSONObject("commonConfig"));
        for (BapSshHostConfiguration hostConfig : newConfigurations) {
            hostConfig.setCommonConfig(this.commonConfig);
        }
        this.hostConfigurations.replaceBy((Collection)newConfigurations);
        this.save();
        return true;
    }

    public boolean canSetMasterNodeName() {
        return Hudson.getVersion().isOlderThan(new VersionNumber("1.414"));
    }

    public BapSshPublisherDescriptor getPublisherDescriptor() {
        return (BapSshPublisherDescriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherDescriptor.class);
    }

    public BapSshHostConfigurationDescriptor getHostConfigurationDescriptor() {
        return (BapSshHostConfigurationDescriptor)Hudson.getInstance().getDescriptorByType(BapSshHostConfigurationDescriptor.class);
    }

    public FormValidation doTestConnection(StaplerRequest request, StaplerResponse response) {
        BapSshHostConfiguration hostConfig = (BapSshHostConfiguration)((Object)request.bindParameters(BapSshHostConfiguration.class, ""));
        hostConfig.setCommonConfig(request.bindParameters(BapSshCommonConfiguration.class, "common."));
        BPBuildInfo buildInfo = this.createDummyBuildInfo();
        try {
            hostConfig.createClient(buildInfo).disconnect();
            return FormValidation.ok((String)Messages.descriptor_testConnection_ok());
        }
        catch (Exception e) {
            return FormValidation.errorWithMarkup((String)("<p>" + Messages.descriptor_testConnection_error() + "</p><p><pre>" + Util.escape((String)(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage())) + "</pre></p>"));
        }
    }

    private BPBuildInfo createDummyBuildInfo() {
        return new BPBuildInfo(TaskListener.NULL, "", Hudson.getInstance().getRootPath(), null, null);
    }

    public Object readResolve() {
        this.msg = null;
        this.commonConfigClass = null;
        this.hostConfigClass = null;
        return this;
    }
}

