/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Util;
import jenkins.plugins.publish_over.BPTransfer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

public class BapSshTransfer
extends BPTransfer {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_EXEC_TIMEOUT = 120000;
    private String execCommand;
    private int execTimeout;

    public static int getDefaultExecTimeout() {
        return 120000;
    }

    BapSshTransfer(String sourceFiles, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        this(sourceFiles, null, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, execCommand, execTimeout);
    }

    @DataBoundConstructor
    public BapSshTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        super(sourceFiles, excludes, remoteDirectory, removePrefix, remoteDirectorySDF, flatten);
        this.execCommand = execCommand;
        this.execTimeout = execTimeout;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public void setExecCommand(String execCommand) {
        this.execCommand = execCommand;
    }

    public int getExecTimeout() {
        return this.execTimeout;
    }

    public void setExecTimeout(int execTimeout) {
        this.execTimeout = execTimeout;
    }

    public boolean hasExecCommand() {
        return Util.fixEmptyAndTrim((String)this.getExecCommand()) != null;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        BapSshTransfer thatTransfer = (BapSshTransfer)((Object)that);
        return this.createEqualsBuilder(thatTransfer).append((Object)this.execCommand, (Object)thatTransfer.execCommand).append(this.execTimeout, thatTransfer.execTimeout).isEquals();
    }

    public int hashCode() {
        return this.createHashCodeBuilder().append((Object)this.execCommand).append(this.execTimeout).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).append((Object)this.execCommand).append(this.execTimeout).toString();
    }
}

