/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import jenkins.plugins.publish_over.BPPlugin;
import jenkins.plugins.publish_over.BPPluginDescriptor;
import jenkins.plugins.publish_over_ssh.BapSshClient;
import jenkins.plugins.publish_over_ssh.BapSshCommonConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisher;
import jenkins.plugins.publish_over_ssh.Messages;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshPublisherPlugin
extends BPPlugin<BapSshPublisher, BapSshClient, BapSshCommonConfiguration> {
    private static final long serialVersionUID = 1L;
    @Extension
    public static final Descriptor DESCRIPTOR = new Descriptor();

    @DataBoundConstructor
    public BapSshPublisherPlugin(ArrayList<BapSshPublisher> publishers, boolean continueOnError, boolean failOnError, boolean alwaysPublishFromMaster, String masterNodeName) {
        super(Messages.console_message_prefix(), publishers, continueOnError, failOnError, alwaysPublishFromMaster, masterNodeName);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.createEqualsBuilder((BapSshPublisherPlugin)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.createHashCodeBuilder().toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public BapSshHostConfiguration getConfiguration(String name) {
        return (BapSshHostConfiguration)DESCRIPTOR.getConfiguration(name);
    }

    public static class DescriptorMessages
    implements BPPluginDescriptor.BPDescriptorMessages {
        public String displayName() {
            return Messages.descriptor_displayName();
        }

        public String connectionOK() {
            return Messages.descriptor_testConnection_ok();
        }

        public String connectionErr() {
            return Messages.descriptor_testConnection_error();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Descriptor
    extends BPPluginDescriptor<BapSshHostConfiguration, BapSshCommonConfiguration> {
        public Descriptor() {
            super((BPPluginDescriptor.BPDescriptorMessages)new DescriptorMessages(), BapSshPublisherPlugin.class, BapSshHostConfiguration.class, BapSshCommonConfiguration.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
        }

        public FormValidation doCheckKeyPath(@QueryParameter String value) {
            if (Hudson.getVersion().isOlderThan(new VersionNumber("1.399"))) {
                return FormValidation.ok();
            }
            try {
                return Hudson.getInstance().getRootPath().validateRelativePath(value, true, true);
            }
            catch (IOException ioe) {
                return FormValidation.error((Throwable)ioe, (String)"");
            }
        }

        public FormValidation doCheckSourceFiles(@QueryParameter String configName, @QueryParameter String sourceFiles, @QueryParameter String execCommand) {
            if (Util.fixEmptyAndTrim((String)configName) != null) {
                BapSshHostConfiguration hostConfig = (BapSshHostConfiguration)this.getConfiguration(configName);
                if (hostConfig == null) {
                    return FormValidation.error((String)Messages.descriptor_sourceFiles_check_configNotFound(configName));
                }
                if (hostConfig.isEffectiveDisableExec()) {
                    return FormValidation.validateRequired((String)sourceFiles);
                }
            }
            return this.checkTransferSet(sourceFiles, execCommand);
        }

        public FormValidation doCheckExecCommand(@QueryParameter String sourceFiles, @QueryParameter String execCommand) {
            return this.checkTransferSet(sourceFiles, execCommand);
        }

        public FormValidation doCheckExecTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        private FormValidation checkTransferSet(String sourceFiles, String execCommand) {
            return this.haveAtLeastOne(sourceFiles, execCommand) ? FormValidation.ok() : FormValidation.error((String)Messages.descriptor_sourceOrExec());
        }

        private boolean haveAtLeastOne(String ... values) {
            for (String value : values) {
                if (Util.fixEmptyAndTrim((String)value) == null) continue;
                return true;
            }
            return false;
        }

        public Descriptor getPublisherDescriptor() {
            return this;
        }
    }
}

