/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Util;
import hudson.util.Secret;
import java.io.Serializable;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over_ssh.BapSshUtil;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

public class BapSshKeyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String passphrase;
    private Secret secretPassphrase;
    private String key;
    private String keyPath;

    @DataBoundConstructor
    public BapSshKeyInfo(String passphrase, String key, String keyPath) {
        this.secretPassphrase = Secret.fromString((String)passphrase);
        this.key = key;
        this.keyPath = keyPath;
    }

    protected final String getPassphrase() {
        return Secret.toString((Secret)this.secretPassphrase);
    }

    public final void setPassphrase(String passphrase) {
        this.secretPassphrase = Secret.fromString((String)passphrase);
    }

    public final String getEncryptedPassphrase() {
        return this.secretPassphrase == null ? null : this.secretPassphrase.getEncryptedValue();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public byte[] getEffectiveKey(BPBuildInfo buildInfo) {
        if (this.hasKey()) {
            return BapSshUtil.toBytes(this.key);
        }
        return buildInfo.readFileFromMaster(this.keyPath.trim());
    }

    public boolean useKey() {
        return this.hasKey() || this.hasKeyPath();
    }

    private boolean hasKey() {
        return Util.fixEmptyAndTrim((String)this.key) != null;
    }

    private boolean hasKeyPath() {
        return Util.fixEmptyAndTrim((String)this.keyPath) != null;
    }

    protected HashCodeBuilder createHashCodeBuilder() {
        return this.addToHashCode(new HashCodeBuilder());
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.secretPassphrase).append((Object)this.key).append((Object)this.keyPath);
    }

    protected EqualsBuilder createEqualsBuilder(BapSshKeyInfo that) {
        return this.addToEquals(new EqualsBuilder(), that);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapSshKeyInfo that) {
        return builder.append((Object)this.secretPassphrase, (Object)that.secretPassphrase).append((Object)this.key, (Object)that.key).append((Object)this.keyPath, (Object)that.keyPath);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("passphrase", (Object)"***").append("key", (Object)"***").append("keyPath", (Object)this.keyPath);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.createEqualsBuilder((BapSshKeyInfo)that).isEquals();
    }

    public int hashCode() {
        return this.createHashCodeBuilder().toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public Object readResolve() {
        if (this.secretPassphrase == null) {
            this.secretPassphrase = Secret.fromString((String)this.passphrase);
        }
        this.passphrase = null;
        return this;
    }
}

