/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pom2config.handler;

import hudson.Extension;
import hudson.model.AbstractProject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pom2config.DataSet;
import org.jenkinsci.plugins.pom2config.Pom2ConfigHandler;
import org.w3c.dom.Document;

@Extension
public class JobHandler
extends Pom2ConfigHandler {
    public JobHandler() {
        super(new JobHandlerSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobHandlerSpec
    extends Pom2ConfigHandler.Pom2ConfigHandlerSpec {
        private static final Logger LOG = Logger.getLogger(JobHandler.class.getName());
        private final String descLabel = "Project Description";

        @Override
        public String getName() {
            return "Values which every Job has";
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public boolean isActivatedInJob(AbstractProject<?, ?> project) {
            return true;
        }

        @Override
        public List<DataSet> parsePom(AbstractProject<?, ?> project, Document doc) throws IOException {
            ArrayList<String> oldDescription = new ArrayList<String>();
            oldDescription.add(project.getDescription());
            DataSet description = new DataSet("Project Description", true, oldDescription, this.retrieveDetailsFromPom(doc, "//description/text()"));
            this.pomValues.add(description);
            return this.pomValues;
        }

        @Override
        public String setDetails(AbstractProject<?, ?> project, JSONObject formData) {
            String newDescription = formData.getJSONObject("Project Description").getString("pomEntry").trim();
            if (!newDescription.isEmpty()) {
                try {
                    project.setDescription(formData.getJSONObject("Project Description").getString("pomEntry").trim());
                }
                catch (IOException ex) {
                    LOG.finest("Unable to change project description." + ex.getMessage());
                    return "Description not replaced";
                }
                return "Description replaced";
            }
            return "Description not replaced";
        }
    }
}

