/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.plot.MatrixPlotPublisher;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotReport;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MatrixPlotAction
implements Action,
StaplerProxy {
    private MatrixConfiguration project;
    private MatrixPlotPublisher publisher;

    public MatrixPlotAction(MatrixConfiguration project, MatrixPlotPublisher publisher) {
        this.project = project;
        this.publisher = publisher;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean hasPlots() throws IOException {
        return CollectionUtils.isNotEmpty(this.publisher.getPlots(this.project));
    }

    public List<String> getOriginalGroups() {
        return this.publisher.getOriginalGroups(this.project);
    }

    public String getUrlGroup(String originalGroup) {
        return this.publisher.originalGroupToUrlEncodedGroup(originalGroup);
    }

    public PlotReport getDynamic(String group, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return new PlotReport((AbstractProject<?, ?>)this.project, this.publisher.urlGroupToOriginalGroup(this.getUrlGroup(group), this.project), this.publisher.getPlots(this.getUrlGroup(group), this.project));
    }

    public Object getTarget() {
        List<String> groups = this.getOriginalGroups();
        if (groups != null && groups.size() == 1) {
            return new PlotReport((AbstractProject<?, ?>)this.project, groups.get(0), this.publisher.getPlots(this.getUrlGroup(groups.get(0)), this.project));
        }
        return this;
    }

    public String getDisplayName() {
        return Messages.Plot_Action_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return Messages.Plot_UrlName();
    }
}

