/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.plot.AbstractPlotPublisher;
import hudson.plugins.plot.MatrixPlotAction;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.SeriesFactory;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixPlotPublisher
extends AbstractPlotPublisher {
    private transient Map<MatrixConfiguration, List<Plot>> plotsOfConfigurations = new HashMap<MatrixConfiguration, List<Plot>>();
    private transient Map<String, List<Plot>> groupMap = new HashMap<String, List<Plot>>();
    private List<Plot> plots = new ArrayList<Plot>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public String urlGroupToOriginalGroup(String urlGroup, MatrixConfiguration c) {
        if (urlGroup == null || "nogroup".equals(urlGroup)) {
            return "Plots";
        }
        if (this.groupMap.containsKey(urlGroup)) {
            ArrayList<Plot> plots = new ArrayList<Plot>();
            for (Plot plot : this.groupMap.get(urlGroup)) {
                if (!ObjectUtils.equals(plot.getProject(), (Object)c)) continue;
                plots.add(plot);
            }
            if (plots.size() > 0) {
                return ((Plot)plots.get((int)0)).group;
            }
        }
        return "";
    }

    public List<String> getOriginalGroups(MatrixConfiguration configuration) {
        ArrayList<String> originalGroups = new ArrayList<String>();
        for (String urlGroup : this.groupMap.keySet()) {
            originalGroups.add(this.urlGroupToOriginalGroup(urlGroup, configuration));
        }
        Collections.sort(originalGroups);
        return originalGroups;
    }

    public void setPlots(List<Plot> plots) {
        this.plots = plots;
        this.groupMap = new HashMap<String, List<Plot>>();
        this.plotsOfConfigurations = new HashMap<MatrixConfiguration, List<Plot>>();
    }

    public void addPlot(Plot plot) {
        List<Object> list;
        String urlGroup = this.originalGroupToUrlEncodedGroup(plot.getGroup());
        if (this.groupMap.containsKey(urlGroup)) {
            list = this.groupMap.get(urlGroup);
            list.add(plot);
        } else {
            list = new ArrayList<Plot>();
            list.add(plot);
            this.groupMap.put(urlGroup, list);
        }
        if (this.plotsOfConfigurations.get((MatrixConfiguration)plot.getProject()) == null) {
            list = new ArrayList();
            list.add(plot);
            this.plotsOfConfigurations.put((MatrixConfiguration)plot.getProject(), list);
        } else {
            this.plotsOfConfigurations.get((MatrixConfiguration)plot.getProject()).add(plot);
        }
    }

    public List<Plot> getPlots(MatrixConfiguration configuration) {
        ArrayList p = this.plotsOfConfigurations.get(configuration);
        return p != null ? p : new ArrayList();
    }

    public List<Plot> getPlots() {
        return this.plots;
    }

    public List<Plot> getPlots(String urlGroup, MatrixConfiguration configuration) {
        ArrayList<Plot> groupPlots = new ArrayList<Plot>();
        List<Plot> p = this.groupMap.get(urlGroup);
        if (p != null) {
            for (Plot plot : p) {
                if (!ObjectUtils.equals(plot.getProject(), (Object)configuration)) continue;
                groupPlots.add(plot);
            }
        }
        return groupPlots;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        if (project instanceof MatrixConfiguration) {
            return new MatrixPlotAction((MatrixConfiguration)project, this);
        }
        return null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (!this.plotsOfConfigurations.containsKey((MatrixConfiguration)build.getProject())) {
            for (Plot p : this.plots) {
                Plot plot = new Plot(p.title, p.yaxis, p.group, p.numBuilds, p.csvFileName, p.style, p.useDescr);
                plot.series = p.series;
                plot.setProject((AbstractProject<?, ?>)((MatrixConfiguration)build.getProject()));
                this.addPlot(plot);
            }
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!(build instanceof MatrixBuild)) {
            return true;
        }
        listener.getLogger().println("Recording plot data");
        for (Plot plot : this.plotsOfConfigurations.get((MatrixConfiguration)build.getProject())) {
            plot.addBuild(build, listener.getLogger());
        }
        return true;
    }

    private Object readResolve() {
        this.setPlots(this.plots);
        return this;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(MatrixPlotPublisher.class);
        }

        public String getDisplayName() {
            return Messages.Plot_Publisher_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return MatrixProject.class.isAssignableFrom(jobType);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MatrixPlotPublisher publisher = new MatrixPlotPublisher();
            ArrayList<Plot> plots = new ArrayList<Plot>();
            for (Object data : SeriesFactory.getArray(formData.get("plots"))) {
                plots.add(DescriptorImpl.bindPlot((JSONObject)data, req));
            }
            publisher.setPlots(plots);
            return publisher;
        }

        private static Plot bindPlot(JSONObject data, StaplerRequest req) {
            Plot p = (Plot)req.bindJSON(Plot.class, data);
            p.series = SeriesFactory.createSeriesList(data.get("series"), req);
            return p;
        }

        public FormValidation doCheckSeriesFile(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }
}

