/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.FilePath;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(Series.class.getName());
    private static final transient Level defaultLogLevel = Level.INFO;
    private static final transient Pattern PAT_NAME = Pattern.compile("%name%");
    private static final transient Pattern PAT_INDEX = Pattern.compile("%index%");
    private static final transient Map<String, QName> qnameMap;
    private String xpathString;
    private String url;
    private String nodeTypeString;
    private transient QName nodeType;

    @DataBoundConstructor
    public XMLSeries(String file, String xpath, String nodeType, String url) {
        super(file, "", "xml");
        this.xpathString = xpath;
        this.nodeTypeString = nodeType;
        this.nodeType = qnameMap.get(nodeType);
        this.url = url;
    }

    private Object readResolve() {
        this.nodeType = qnameMap.get(this.nodeTypeString);
        return this;
    }

    public String getXpath() {
        return this.xpathString;
    }

    public String getNodeType() {
        return this.nodeTypeString;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlotPoint[] loadSeries(FilePath workspaceRootDir, PrintStream logger) {
        block36: {
            PlotPoint[] plotPointArray;
            InputStream in = null;
            InputSource inputSource = null;
            try {
                ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
                FilePath[] seriesFiles = null;
                try {
                    seriesFiles = workspaceRootDir.list(this.getFile());
                }
                catch (Exception e) {
                    LOGGER.warning("Exception trying to retrieve series files: " + e);
                    PlotPoint[] plotPointArray2 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    return plotPointArray2;
                }
                if (seriesFiles != null && seriesFiles.length < 1) {
                    LOGGER.info("No plot data file found: " + this.getFile());
                    PlotPoint[] e = null;
                    return e;
                }
                try {
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Loading plot series data from: " + this.getFile());
                    }
                    in = seriesFiles[0].read();
                    inputSource = new InputSource(in);
                }
                catch (Exception e) {
                    LOGGER.warning("Exception reading plot series data from: " + seriesFiles[0] + " " + e);
                    PlotPoint[] ignore = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore2) {
                            // empty catch block
                        }
                    }
                    return ignore;
                }
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "NodeType " + this.nodeTypeString + " : " + this.nodeType);
                }
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Loaded XML Plot file: " + this.getFile());
                }
                XPath xpath = XPathFactory.newInstance().newXPath();
                Object xmlObject = xpath.evaluate(this.xpathString, inputSource, this.nodeType);
                if (this.nodeType.equals(XPathConstants.NODESET)) {
                    NodeList nl = (NodeList)xmlObject;
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Number of nodes: " + nl.getLength());
                    }
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (n == null || n.getLocalName() == null || n.getTextContent() == null) continue;
                        this.addValueToList(ret, n.getLocalName().trim(), n.getTextContent().trim());
                    }
                } else {
                    this.addValueToList(ret, this.label, xmlObject);
                }
                plotPointArray = ret.toArray(new PlotPoint[ret.size()]);
            }
            catch (XPathExpressionException e) {
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Exception: " + e);
                }
                break block36;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return plotPointArray;
        }
        return null;
    }

    private String getUrl(String label, int index) {
        Matcher indexMatcher;
        Matcher nameMatcher = PAT_NAME.matcher(label);
        if (nameMatcher.find()) {
            this.url = nameMatcher.replaceAll(label);
        }
        if ((indexMatcher = PAT_INDEX.matcher(label)).find()) {
            this.url = indexMatcher.replaceAll(label);
        }
        return this.url;
    }

    private String nodeToString(Object obj) {
        String ret = null;
        if (this.nodeType == XPathConstants.BOOLEAN) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (this.nodeType == XPathConstants.NUMBER) {
            return ((Double)obj).toString().trim();
        }
        if (this.nodeType == XPathConstants.NODE) {
            ret = ((Node)obj).toString().trim();
        }
        if (this.nodeType == XPathConstants.STRING || this.nodeType == XPathConstants.NODESET) {
            ret = ((String)obj).trim();
        }
        if (ret != null) {
            try {
                Double.parseDouble(ret);
                return ret;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private void addValueToList(List<PlotPoint> list, String label, Object nodeValue) {
        String value = this.nodeToString(nodeValue);
        if (value != null) {
            if (LOGGER.isLoggable(defaultLogLevel)) {
                LOGGER.log(defaultLogLevel, "Adding node: " + label + " value: " + value);
            }
            list.add(new PlotPoint(value, this.getUrl(label, 0), label));
        } else if (LOGGER.isLoggable(defaultLogLevel)) {
            LOGGER.log(defaultLogLevel, "Unable to add node: " + label + " value: " + nodeValue);
        }
    }

    static {
        HashMap<String, QName> tempMap = new HashMap<String, QName>();
        tempMap.put("BOOLEAN", XPathConstants.BOOLEAN);
        tempMap.put("NODE", XPathConstants.NODE);
        tempMap.put("NODESET", XPathConstants.NODESET);
        tempMap.put("NUMBER", XPathConstants.NUMBER);
        tempMap.put("STRING", XPathConstants.STRING);
        qnameMap = Collections.unmodifiableMap(tempMap);
    }
}

