/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.json.JSON;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.WriteJSONStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteJSONStep
extends Step {
    private final String file;
    private final JSON json;
    private int pretty = 0;

    @DataBoundConstructor
    public WriteJSONStep(String file, JSON json) {
        this.file = Util.fixNull((String)file);
        this.json = json;
    }

    public String getFile() {
        return this.file;
    }

    public JSON getJson() {
        return this.json;
    }

    public int getPretty() {
        return this.pretty;
    }

    @DataBoundSetter
    void setPretty(int pretty) {
        this.pretty = pretty;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WriteJSONStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "writeJSON";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.WriteJSONStep_DescriptorImpl_displayName();
        }
    }
}

