/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import com.google.common.util.concurrent.FutureCallback;
import hudson.Extension;
import hudson.FilePath;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.output.TeeOutputStream;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeeStep
extends Step {
    public final String file;

    @DataBoundConstructor
    public TeeStep(String file) {
        this.file = file;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.file);
    }

    private static OutputStream append(FilePath fp) throws IOException, InterruptedException {
        if (fp.getChannel() == null) {
            File f = new File(fp.getRemote()).getAbsoluteFile();
            if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                throw new IOException("Failed to create directory " + f.getParentFile());
            }
            try {
                return Files.newOutputStream(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        return (OutputStream)fp.act((FilePath.FileCallable)new MasterToSlaveFileCallable<OutputStream>(){
            private static final long serialVersionUID = 1L;

            public OutputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                if (!(f = f.getAbsoluteFile()).getParentFile().exists() && !f.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + f.getParentFile());
                }
                try {
                    return new RemoteOutputStream(Files.newOutputStream(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND));
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "tee";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Tee output to file";
        }
    }

    private static class TeeFilter
    extends ConsoleLogFilter
    implements Serializable {
        private final FilePath f;
        private static final long serialVersionUID = 1L;

        TeeFilter(FilePath f) {
            this.f = f;
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
            return new TeeOutputStream(logger, TeeStep.append(this.f));
        }
    }

    private static class Execution
    extends StepExecution {
        private final String file;
        private static final long serialVersionUID = 1L;

        Execution(StepContext context, String file) {
            super(context);
            this.file = file;
        }

        public boolean start() throws Exception {
            FilePath f = ((FilePath)this.getContext().get(FilePath.class)).child(this.file);
            this.getContext().newBodyInvoker().withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)new TeeFilter(f))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }
    }
}

