/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Formatter;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FileSha1Step
extends Step {
    private final String file;

    @DataBoundConstructor
    public FileSha1Step(String file) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(this, context);
    }

    public static class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private transient FileSha1Step step;

        protected ExecutionImpl(@Nonnull FileSha1Step step, @Nonnull StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            FilePath filePath = ws.child(this.step.getFile());
            return (String)filePath.act((FilePath.FileCallable)new ComputeSha1());
        }

        private static class ComputeSha1
        extends MasterToSlaveFileCallable<String> {
            private ComputeSha1() {
            }

            public String invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                if (file.exists() && file.isFile()) {
                    try {
                        return this.sha1(file);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                return null;
            }

            public String sha1(File file) throws NoSuchAlgorithmException, IOException {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                    byte[] object = new byte[1024];
                    int read = 0;
                    while ((read = ((InputStream)is).read(object)) != -1) {
                        messageDigest.update(object, 0, read);
                    }
                }
                var4_4 = null;
                try (Formatter formatter = new Formatter();){
                    for (byte b : messageDigest.digest()) {
                        formatter.format("%02x", b);
                    }
                    String string = formatter.toString();
                    return string;
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "sha1";
        }

        @Nonnull
        public String getDisplayName() {
            return "Compute the SHA1 of a given file";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

