/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.ZipStep;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class ZipStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    private transient ZipStep step;

    protected ZipStepExecution(@Nonnull ZipStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        FilePath destination;
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        FilePath source = ws;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            source = ws.child(this.step.getDir());
            if (!source.exists()) {
                throw new IOException(source.getRemote() + " does not exist.");
            }
            if (!source.isDirectory()) {
                throw new IOException(source.getRemote() + " is not a directory.");
            }
        }
        if ((destination = ws.child(this.step.getZipFile())).exists()) {
            throw new IOException(destination.getRemote() + " exists.");
        }
        if (StringUtils.isBlank((String)this.step.getGlob())) {
            listener.getLogger().println("Writing zip file of " + source.getRemote() + " to " + destination.getRemote());
        } else {
            listener.getLogger().println("Writing zip file of " + source.getRemote() + " filtered by [" + this.step.getGlob() + "] to " + destination.getRemote());
        }
        int count = (Integer)source.act((FilePath.FileCallable)new ZipItFileCallable(destination, this.step.getGlob()));
        listener.getLogger().println("Zipped " + count + " entries.");
        if (this.step.isArchive()) {
            Run build = (Run)this.getContext().get(Run.class);
            if (build == null) {
                throw new MissingContextVariableException(Run.class);
            }
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            if (launcher == null) {
                throw new MissingContextVariableException(Launcher.class);
            }
            listener.getLogger().println("Archiving " + destination.getRemote());
            HashMap<String, String> files = new HashMap<String, String>();
            String s = this.step.getZipFile().replace('\\', '/');
            files.put(s, s);
            build.pickArtifactManager().archive(ws, launcher, (BuildListener)new BuildListenerAdapter(listener), files);
        }
        return null;
    }

    static class ZipItFileCallable
    extends MasterToSlaveFileCallable<Integer> {
        final FilePath zipFile;
        final String glob;

        public ZipItFileCallable(FilePath zipFile, String glob) {
            this.zipFile = zipFile;
            this.glob = StringUtils.isBlank((String)glob) ? "**/*" : glob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            String canonicalZip = new File(this.zipFile.getRemote()).getCanonicalPath();
            Archiver archiver = ArchiverFactory.ZIP.create(this.zipFile.write());
            FileSet fs = Util.createFileSet((File)dir, (String)this.glob);
            DirectoryScanner scanner = fs.getDirectoryScanner(new Project());
            try {
                for (String path : scanner.getIncludedFiles()) {
                    File toArchive = new File(dir, path).getCanonicalFile();
                    if (toArchive.getPath().equals(canonicalZip)) continue;
                    archiver.visit(toArchive, path);
                }
            }
            finally {
                archiver.close();
            }
            return archiver.countEntries();
        }
    }
}

