/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.ZipStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ZipStep
extends Step {
    private final String zipFile;
    private String dir;
    private String glob;
    private boolean archive = false;

    @DataBoundConstructor
    public ZipStep(String zipFile) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)zipFile)) {
            throw new Descriptor.FormException("Can not be empty", "zipFile");
        }
        this.zipFile = zipFile;
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public String getDir() {
        return this.dir;
    }

    @DataBoundSetter
    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getGlob() {
        return this.glob;
    }

    @DataBoundSetter
    public void setGlob(String glob) {
        this.glob = glob;
    }

    public boolean isArchive() {
        return this.archive;
    }

    @DataBoundSetter
    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ZipStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "zip";
        }

        public String getDisplayName() {
            return "Create Zip file";
        }
    }
}

